/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    int detail;
    boolean dragSent;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        int n2 = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0);
        if (n2 == 0) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? this.gtk_scrollbar_new(0, n2) : this.gtk_scrollbar_new(1, n2);
        if (this.handle == 0) {
            this.error(2);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0) || (this.style & 0x200) != 0) {
            this.gtk_widget_set_can_focus(this.handle, true);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        this.detail = 0;
        this.dragSent = false;
        return n3;
    }

    int gtk_change_value(int n, int n2, int n3, int n4) {
        this.detail = n2;
        return 0;
    }

    int gtk_value_changed(int n) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
                break;
            }
        }
        return super.gtk_event_after(n, n2);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.closures[7], false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
    }

    void register() {
        super.register();
        int n = OS.gtk_range_get_adjustment(this.handle);
        this.display.addWidget(n, this);
    }

    void deregister() {
        super.deregister();
        int n = OS.gtk_range_get_adjustment(this.handle);
        this.display.removeWidget(n);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        OS.gtk_widget_realize(this.handle);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x100) != 0) {
            if (n == -1) {
                point.x = 2 * point.x;
            }
        } else if (n2 == -1) {
            point.y = 2 * point.y;
        }
        return point;
    }

    public int getIncrement() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_step_increment(n);
    }

    public int getMaximum() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_upper(n);
    }

    public int getMinimum() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_lower(n);
    }

    public int getPageIncrement() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_page_increment(n);
    }

    public int getSelection() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_value(n);
    }

    public int getThumb() {
        this.checkWidget();
        int n = OS.gtk_range_get_adjustment(this.handle);
        return (int)this.gtk_adjustment_get_page_size(n);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_range_set_increments(this.handle, n, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(n2, gtkAdjustment);
        int n3 = (int)gtkAdjustment.lower;
        if (n <= n3) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n3);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(n2, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(n2, gtkAdjustment);
        int n3 = (int)gtkAdjustment.upper;
        if (n >= n3) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n3 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(n2, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!((this.style & 0x4000000) == 0 && bl || (this.style & 0x100) == 0)) {
            OS.gtk_range_set_inverted(this.handle, (this.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_range_set_increments(this.handle, this.getIncrement(), n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_range_set_value(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(n2, gtkAdjustment);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(n2, gtkAdjustment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        int n7 = OS.gtk_range_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        this.gtk_adjustment_configure(n7, gtkAdjustment);
        OS.gtk_adjustment_value_changed(n7);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    int gtk_scrollbar_new(int n, int n2) {
        int n3 = 0;
        n3 = OS.GTK3 ? OS.gtk_scrollbar_new(n, n2) : (n == 0 ? OS.gtk_hscrollbar_new(n2) : OS.gtk_vscrollbar_new(n2));
        return n3;
    }
}

