/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.command.JdbcInterfaceType;
import de.simplicit.vjdbc.command.ParameterTypeCombinations;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectiveCommand
implements Command,
Externalizable {
    static final long serialVersionUID = 1573361368678688726L;
    private static Log _logger = LogFactory.getLog(ReflectiveCommand.class);
    private static final Object[] _zeroParameters = new Object[0];
    private int _interfaceType;
    private String _cmd;
    private Object[] _parameters;
    private int _parameterTypes;
    private transient Class _targetClass;

    public ReflectiveCommand() {
    }

    public ReflectiveCommand(int interfaceType, String cmd) {
        this._interfaceType = interfaceType;
        this._cmd = cmd;
        this._parameters = _zeroParameters;
    }

    public ReflectiveCommand(int interfaceType, String cmd, Object[] parms, int parmTypes) {
        this._interfaceType = interfaceType;
        this._cmd = cmd;
        this._parameters = parms;
        this._parameterTypes = parmTypes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._interfaceType);
        out.writeUTF(this._cmd);
        out.writeInt(this._parameters.length);
        for (int i = 0; i < this._parameters.length; ++i) {
            out.writeObject(this._parameters[i]);
        }
        out.writeInt(this._parameterTypes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._interfaceType = in.readInt();
        this._cmd = in.readUTF();
        int len = in.readInt();
        this._parameters = new Object[len];
        for (int i = 0; i < this._parameters.length; ++i) {
            this._parameters[i] = in.readObject();
        }
        this._parameterTypes = in.readInt();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        try {
            this._targetClass = JdbcInterfaceType._interfaces[this._interfaceType];
            Method method = this._targetClass.getDeclaredMethod(this._cmd, ParameterTypeCombinations._typeCombinations[this._parameterTypes]);
            return method.invoke(target, this._parameters);
        }
        catch (NoSuchMethodException e) {
            String msg = "No such method '" + this._cmd + "' on object " + target + " (Target-Class " + this._targetClass.getName() + ")";
            _logger.warn((Object)msg);
            _logger.warn((Object)this.getParameterTypesAsString());
            throw SQLExceptionHelper.wrap(e);
        }
        catch (SecurityException e) {
            String msg = "Security exception with '" + this._cmd + "' on object " + target;
            _logger.error((Object)msg, (Throwable)e);
            throw SQLExceptionHelper.wrap(e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access exception with '" + this._cmd + "' on object " + target;
            _logger.error((Object)msg, (Throwable)e);
            throw SQLExceptionHelper.wrap(e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Illegal argument exception with '" + this._cmd + "' on object " + target;
            _logger.error((Object)msg, (Throwable)e);
            throw SQLExceptionHelper.wrap(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            String msg = "Unexpected invocation target exception: " + targetException.toString();
            _logger.warn((Object)msg, targetException);
            throw SQLExceptionHelper.wrap(targetException);
        }
        catch (Exception e) {
            String msg = "Unexpected exception: " + e.toString();
            _logger.error((Object)msg, (Throwable)e);
            throw SQLExceptionHelper.wrap(e);
        }
    }

    public int getInterfaceType() {
        return this._interfaceType;
    }

    public void setInterfaceType(int interfaceType) {
        this._interfaceType = interfaceType;
    }

    public String getCommand() {
        return this._cmd;
    }

    public void setCommand(String cmd) {
        this._cmd = cmd;
    }

    public Object[] getParameters() {
        return this._parameters;
    }

    public void setParameters(Object[] parameters) {
        this._parameters = parameters;
    }

    public int getParameterTypes() {
        return this._parameterTypes;
    }

    public void setParameterTypes(int parameterTypes) {
        this._parameterTypes = parameterTypes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReflectiveCommand '").append(this._cmd).append("'");
        if (this._targetClass != null) {
            sb.append(" on object of class ").append(this._targetClass.getName());
        }
        if (this._parameters.length > 0) {
            sb.append(" with ").append(this._parameters.length).append(" parameters\n");
            int n = this._parameters.length;
            for (int i = 0; i < n; ++i) {
                sb.append("\t[").append(i).append("] ");
                if (this._parameters[i] != null) {
                    String value = this._parameters[i].toString();
                    if (value.length() > 0) {
                        sb.append(value);
                    } else {
                        sb.append("<empty>");
                    }
                } else {
                    sb.append("<null>");
                }
                if (i >= n - 1) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String getParameterTypesAsString() {
        Class[] parameterTypes = ParameterTypeCombinations._typeCombinations[this._parameterTypes];
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < parameterTypes.length; ++i) {
            buff.append("Parameter-Type ").append(i).append(": ").append(parameterTypes[i].getName()).append("\n");
        }
        return buff.toString();
    }
}

