/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.SymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.TransportBindingHandler;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.ThreadLocalSecurityProvider;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AsymmetricBinding;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.TransportBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyBasedWSS4JOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SECURITY_PROCESSED = PolicyBasedWSS4JOutInterceptor.class.getName() + ".DONE";
    public static final PolicyBasedWSS4JOutInterceptor INSTANCE = new PolicyBasedWSS4JOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JOutInterceptor.class);
    private PolicyBasedWSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut = new SAAJOutInterceptor();

    public PolicyBasedWSS4JOutInterceptor() {
        super("pre-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        boolean enableStax = MessageUtils.isTrue((Object)mc.getContextualProperty("ws-security.enable.streaming"));
        if (!enableStax) {
            if (mc.getContent(SOAPMessage.class) == null) {
                this.saajOut.handleMessage(mc);
            }
            mc.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
            mc.getInterceptorChain().add((Interceptor)this.ending);
        }
    }

    public void handleFault(SoapMessage message) {
        this.saajOut.handleFault(message);
    }

    public final PolicyBasedWSS4JOutInterceptorInternal createEndingInterceptor() {
        return new PolicyBasedWSS4JOutInterceptorInternal();
    }

    public final class PolicyBasedWSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SoapMessage message) throws Fault {
            Object provider = message.getExchange().get(Provider.class);
            boolean useCustomProvider = provider != null && ThreadLocalSecurityProvider.isInstalled();
            try {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.setProvider((Provider)((Provider)provider));
                }
                this.handleMessageInternal(message);
            }
            finally {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.unsetProvider();
                }
            }
        }

        private void handleMessageInternal(SoapMessage message) throws Fault {
            AssertionInfoMap aim;
            SOAPMessage saaj = (SOAPMessage)message.getContent(SOAPMessage.class);
            boolean mustUnderstand = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.must-understand", (boolean)true);
            String actor = (String)message.getContextualProperty("ws-security.actor");
            if (AttachmentUtil.isMtomEnabled((Message)message) && this.hasAttachments(message)) {
                LOG.warning("MTOM is enabled with WS-Security. Please note that if an attachment isreferenced in the SOAP Body, only the reference will be signed and not theSOAP Body!");
            }
            if ((aim = (AssertionInfoMap)message.get(AssertionInfoMap.class)) != null) {
                AbstractBinding transport = null;
                Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "TransportBinding");
                if (!ais.isEmpty()) {
                    for (AssertionInfo ai : ais) {
                        transport = (AbstractBinding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if (!(ais = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding")).isEmpty()) {
                    for (AssertionInfo ai : ais) {
                        transport = (AbstractBinding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if (!(ais = this.getAllAssertionsByLocalname(aim, "SymmetricBinding")).isEmpty()) {
                    for (AssertionInfo ai : ais) {
                        transport = (AbstractBinding)ai.getAssertion();
                        ai.setAsserted(true);
                    }
                }
                if (transport == null && PolicyBasedWSS4JOutInterceptor.this.isRequestor((Message)message)) {
                    Policy policy = new Policy();
                    transport = new TransportBinding(SPConstants.SPVersion.SP11, policy);
                }
                if (transport != null) {
                    String symSignatureAlgorithm;
                    WSSecHeader secHeader = new WSSecHeader(actor, mustUnderstand);
                    Element el = null;
                    try {
                        el = secHeader.insertSecurityHeader((Document)saaj.getSOAPPart());
                    }
                    catch (WSSecurityException e) {
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
                    }
                    try {
                        SAAJUtils.getHeader((SOAPMessage)saaj).removeChild((Node)el);
                        SAAJUtils.getHeader((SOAPMessage)saaj).appendChild((Node)el);
                    }
                    catch (SOAPException e) {
                        // empty catch block
                    }
                    WSSConfig config = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
                    if (config == null) {
                        config = WSSConfig.getNewInstance();
                    }
                    this.translateProperties(message);
                    String asymSignatureAlgorithm = (String)message.getContextualProperty("ws-security.asymmetric.signature.algorithm");
                    if (asymSignatureAlgorithm != null && transport.getAlgorithmSuite() != null) {
                        transport.getAlgorithmSuite().setAsymmetricSignature(asymSignatureAlgorithm);
                    }
                    if ((symSignatureAlgorithm = (String)message.getContextualProperty("ws-security.symmetric.signature.algorithm")) != null && transport.getAlgorithmSuite() != null) {
                        transport.getAlgorithmSuite().setSymmetricSignature(symSignatureAlgorithm);
                    }
                    if (transport instanceof TransportBinding) {
                        new TransportBindingHandler(config, (TransportBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else if (transport instanceof SymmetricBinding) {
                        new SymmetricBindingHandler(config, (SymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    } else {
                        new AsymmetricBindingHandler(config, (AsymmetricBinding)transport, saaj, secHeader, aim, message).handleBinding();
                    }
                    if (el.getFirstChild() == null) {
                        el.getParentNode().removeChild(el);
                    }
                }
            }
        }

        private boolean hasAttachments(SoapMessage mc) {
            Collection attachments = mc.getAttachments();
            return attachments != null && attachments.size() > 0;
        }

        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        public String getId() {
            return PolicyBasedWSS4JOutInterceptorInternal.class.getName();
        }

        public String getPhase() {
            return "post-protocol";
        }

        public void handleFault(SoapMessage message) {
        }

        public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
            return null;
        }

        private void translateProperties(SoapMessage msg) {
            String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
            if (bspCompliant != null) {
                msg.put("isBSPCompliant", (Object)bspCompliant);
            }
        }

        private Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
            Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
            Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
            if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
                HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
                if (sp11Ais != null) {
                    ais.addAll(sp11Ais);
                }
                if (sp12Ais != null) {
                    ais.addAll(sp12Ais);
                }
                return ais;
            }
            return Collections.emptySet();
        }
    }
}

