/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="wc", description="Print newline, word, and byte counts for each file.")
public class WcAction
extends AbstractAction {
    @Option(name="-l", aliases={"--lines"}, description="Print the newline counts.", required=false, multiValued=false)
    private boolean lines;
    @Option(name="-w", aliases={"--words"}, description="Print the word counts.", required=false, multiValued=false)
    private boolean words;
    @Option(name="-m", aliases={"--chars"}, description="Print the character counts.", required=false, multiValued=false)
    private boolean chars;
    @Option(name="-c", aliases={"--bytes"}, description="Print the byte counts.", required=false, multiValued=false)
    private boolean bytes;
    @Argument(index=0, name="files", description="The list of files where to perform the count", required=false, multiValued=true)
    private List<File> files;

    protected Object doExecute() throws Exception {
        String outputString;
        this.setDefaultOptions();
        if (this.files == null) {
            WordCounts wordCounts = this.getWordCounts(System.in);
            outputString = this.formatWordCounts(wordCounts, null);
        } else {
            outputString = this.getFilesWordCountReport(this.files);
        }
        System.out.println(outputString);
        return null;
    }

    protected String getFilesWordCountReport(List<File> files) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        WordCounts totalWordCounts = new WordCounts();
        for (File file : files) {
            WordCounts fileWordCount = this.getWordCounts(new FileInputStream(file));
            String fileFormattedString = this.formatWordCounts(fileWordCount, file.getName());
            totalWordCounts = totalWordCounts.add(fileWordCount);
            stringBuilder.append(fileFormattedString).append('\n');
        }
        if (files.size() > 1) {
            stringBuilder.append(this.formatWordCounts(totalWordCounts, "total"));
        }
        String report = stringBuilder.toString();
        return report;
    }

    protected void setDefaultOptions() {
        boolean noOptionsSupplied;
        boolean bl = noOptionsSupplied = !this.bytes && !this.chars && !this.lines && !this.words;
        if (noOptionsSupplied) {
            this.lines = true;
            this.words = true;
            this.bytes = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WordCounts getWordCounts(InputStream inputStream) throws IOException {
        WordCounts wordCounts = new WordCounts();
        BufferedReader bufferedReader = null;
        try {
            int current;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            boolean skipNextLineFeed = false;
            boolean previouslyWhitespace = true;
            while ((current = bufferedReader.read()) != -1) {
                boolean isCurrentWhitespace;
                boolean eol;
                ++wordCounts.byteCount;
                ++wordCounts.charCount;
                boolean isSkipNewlineFeed = skipNextLineFeed && current == 10;
                skipNextLineFeed = false;
                if (isSkipNewlineFeed) continue;
                boolean bl = eol = current == 10 || current == 13;
                if (eol) {
                    ++wordCounts.lineCount;
                    if (current == 13) {
                        skipNextLineFeed = true;
                    }
                }
                if (!(isCurrentWhitespace = Character.isWhitespace(current)) && previouslyWhitespace) {
                    ++wordCounts.wordCount;
                }
                previouslyWhitespace = isCurrentWhitespace;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return wordCounts;
    }

    protected String formatWordCounts(WordCounts wordCounts, String reportName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lines) {
            stringBuilder.append('\t').append(wordCounts.lineCount);
        }
        if (this.words) {
            stringBuilder.append('\t').append(wordCounts.wordCount);
        }
        if (this.chars) {
            stringBuilder.append('\t').append(wordCounts.charCount);
        }
        if (this.bytes) {
            stringBuilder.append('\t').append(wordCounts.byteCount);
        }
        if (reportName != null) {
            stringBuilder.append('\t').append(reportName);
        }
        String formattedString = stringBuilder.toString();
        return formattedString;
    }

    protected static class WordCounts {
        protected int lineCount;
        protected int wordCount;
        protected int byteCount;
        protected int charCount;

        protected WordCounts() {
        }

        public WordCounts add(WordCounts append) {
            WordCounts wordCounts = new WordCounts();
            wordCounts.charCount = this.charCount + append.charCount;
            wordCounts.byteCount = this.byteCount + append.byteCount;
            wordCounts.lineCount = this.lineCount + append.lineCount;
            wordCounts.wordCount = this.wordCount + append.wordCount;
            return wordCounts;
        }
    }
}

