/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.api.java.JavaSparkContext;

public abstract class SparkCounter<T>
implements Serializable {
    private String name;
    private String displayName;
    private Accumulator<T> accumulator;

    public SparkCounter() {
    }

    public SparkCounter(String name, String displayName, String groupName, T initValue, JavaSparkContext sparkContext) {
        this.name = name;
        this.displayName = displayName;
        String accumulatorName = groupName + "_" + name;
        if (sparkContext == null) {
            throw new RuntimeException("Not allowed to create SparkCounter on backend executor.");
        }
        this.accumulator = sparkContext.accumulator(initValue, accumulatorName, this.createAccumulatorParam());
    }

    protected abstract AccumulatorParam<T> createAccumulatorParam();

    public T getValue() {
        if (this.accumulator != null) {
            return (T)this.accumulator.value();
        }
        return null;
    }

    public void increment(T incr) {
        this.accumulator.add(incr);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static class MapSparkCounter
    extends SparkCounter<Map<String, Long>> {
        public MapSparkCounter() {
        }

        public MapSparkCounter(String name, String displayName, String groupName, Map<String, Long> initValue, JavaSparkContext sparkContext) {
            super(name, displayName, groupName, initValue, sparkContext);
        }

        @Override
        protected AccumulatorParam<Map<String, Long>> createAccumulatorParam() {
            return new MapAccumulatorParam();
        }

        private class MapAccumulatorParam
        implements AccumulatorParam<Map<String, Long>> {
            private MapAccumulatorParam() {
            }

            public Map<String, Long> addAccumulator(Map<String, Long> t1, Map<String, Long> t2) {
                return this.addInPlace(t1, t2);
            }

            public Map<String, Long> addInPlace(Map<String, Long> r1, Map<String, Long> r2) {
                for (String key : r2.keySet()) {
                    Long r1val = r1.get(key);
                    Long r2val = r2.get(key);
                    r1.put(key, r1val == null ? r2val : r1val + r2val);
                }
                return r1;
            }

            public Map<String, Long> zero(Map<String, Long> initialValue) {
                return new HashMap<String, Long>();
            }
        }
    }

    public static class LongSparkCounter
    extends SparkCounter<Long> {
        public LongSparkCounter() {
        }

        public LongSparkCounter(String name, String displayName, String groupName, Long initValue, JavaSparkContext sparkContext) {
            super(name, displayName, groupName, initValue, sparkContext);
        }

        @Override
        protected AccumulatorParam<Long> createAccumulatorParam() {
            return new LongAccumulatorParam();
        }

        private class LongAccumulatorParam
        implements AccumulatorParam<Long> {
            private LongAccumulatorParam() {
            }

            public Long addAccumulator(Long t1, Long t2) {
                return t1 + t2;
            }

            public Long addInPlace(Long r1, Long r2) {
                return r1 + r2;
            }

            public Long zero(Long initialValue) {
                return 0L;
            }
        }
    }
}

