/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ftp4che.commands.Command;
import org.ftp4che.commands.ListCommand;
import org.ftp4che.commands.RetrieveCommand;
import org.ftp4che.commands.StoreCommand;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.reply.Reply;

public class ReplyWorker
extends Thread {
    public static final Logger log = Logger.getLogger((String)ReplyWorker.class.getName());
    public static final int FINISHED = 1;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_IO_EXCEPTION = 3;
    public static final int UNKNOWN = -1;
    private Exception caughtException = null;
    private SocketProvider socketProvider;
    private PipedInputStream inputPipe;
    private PipedOutputStream outputPipe;
    private ByteBuffer downloadBuffer;
    private int downloadMethod = 0;
    private Command command;
    private Charset charset = Charset.forName("ISO8859-1");
    private CharsetDecoder charDecoder = this.charset.newDecoder();
    private ByteBuffer buffer = ByteBuffer.allocate(16384);
    private int status = -1;
    private Reply reply;

    public ReplyWorker(SocketProvider sc, Command command) {
        this.setSocketProvider(sc);
        this.setCommand(command);
    }

    public ReplyWorker(SocketProvider sc, Command command, Object res, int method) throws IOException {
        this.setSocketProvider(sc);
        this.setCommand(command);
        this.setDownloadMethod(method);
        switch (this.getDownloadMethod()) {
            case 1: {
                this.setInputPipe((PipedInputStream)res);
                this.outputPipe = new PipedOutputStream();
                this.inputPipe.connect(this.outputPipe);
                break;
            }
            case 2: {
                this.setDownloadBuffer((ByteBuffer)res);
                break;
            }
        }
    }

    public static Reply readReply(SocketProvider socketProvider) throws IOException {
        return ReplyWorker.readReply(socketProvider, false);
    }

    public static Reply readReply(SocketProvider socketProvider, boolean isListReply) throws IOException {
        int amount;
        ArrayList<String> lines = new ArrayList<String>();
        Charset charset = Charset.forName("ISO8859-1");
        CharsetDecoder charDecoder = charset.newDecoder();
        Logger log = Logger.getLogger((String)ReplyWorker.class.getName());
        String output = "";
        String out = "";
        ByteBuffer buf = null;
        buf = !isListReply ? ByteBuffer.allocateDirect(1024) : ByteBuffer.allocateDirect(16384);
        buf.clear();
        socketProvider.socket().setKeepAlive(true);
        boolean read = true;
        while (read && (amount = socketProvider.read(buf)) >= 0) {
            if (amount == 0) {
                try {
                    ReplyWorker.sleep(50L);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            buf.flip();
            out = charDecoder.decode(buf).toString();
            log.debug((Object)("Read data from server (String) -> " + out));
            log.debug((Object)("Read data from server (bytes) -> " + Arrays.toString(out.getBytes())));
            output = output + out;
            buf.clear();
            String[] tmp = output.split("\n");
            if (!isListReply && tmp.length > 0 && tmp[tmp.length - 1].length() > 3 && tmp[tmp.length - 1].endsWith("\r") && tmp[tmp.length - 1].charAt(3) == ' ' && Pattern.matches("[0-9]+", tmp[tmp.length - 1].substring(0, 3))) {
                String[] stringLines = output.split("\n");
                for (int i = 0; i < stringLines.length; ++i) {
                    log.debug((Object)("Adding line to result list -> " + stringLines[i]));
                    lines.add(stringLines[i]);
                }
                read = false;
                output = "";
                buf.clear();
            }
            try {
                ReplyWorker.sleep(50L);
            }
            catch (InterruptedException ie) {}
        }
        if (isListReply) {
            String[] stringLines = output.split("\r\n");
            for (int i = 0; i < stringLines.length; ++i) {
                if (stringLines[i].length() <= 0) continue;
                log.debug((Object)("LIST Reply lines -> " + stringLines[i]));
                lines.add(stringLines[i]);
            }
            output = "";
            buf.clear();
            socketProvider.close();
        }
        return new Reply(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (this.getCommand() == null) {
            throw new IllegalArgumentException("Given command is null!");
        }
        if (this.getSocketProvider() == null) {
            throw new IllegalArgumentException("Given connection is not open!");
        }
        if (this.getCommand() instanceof ListCommand) {
            try {
                this.setReply(ReplyWorker.readReply(this.getSocketProvider(), true));
                this.setStatus(1);
                return;
            }
            catch (IOException ioe) {
                this.setCaughtException(ioe);
                this.setStatus(3);
            }
            return;
        }
        if (this.getCommand() instanceof RetrieveCommand) {
            RetrieveCommand retrieveCommand = (RetrieveCommand)this.getCommand();
            if (retrieveCommand.getFromFile().getTransferType().intern() != "TYPE I" && retrieveCommand.getFromFile().getTransferType().intern() != "TYPE A") throw new IllegalArgumentException("Unknown file transfer type for download!");
            try {
                log.debug((Object)("Download file: " + retrieveCommand.getFromFile().toString()));
                FileOutputStream out = null;
                FileChannel channel = null;
                if (this.getDownloadMethod() == 0) {
                    out = new FileOutputStream(retrieveCommand.getToFile().getFile());
                    channel = out.getChannel();
                    if (retrieveCommand.getResumePosition() != -1L) {
                        try {
                            channel.position(retrieveCommand.getResumePosition());
                        }
                        catch (IOException ioe) {
                            this.setCaughtException(ioe);
                            this.setStatus(3);
                            try {
                                channel.close();
                                return;
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                } else if (this.getDownloadMethod() == 2) {
                    // empty if block
                }
                try {
                    byte[] buf;
                    int amount;
                    while ((amount = this.getSocketProvider().read(this.buffer)) != -1) {
                        if (amount == 0) {
                            try {
                                Thread.sleep(4L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        this.buffer.flip();
                        while (this.buffer.hasRemaining()) {
                            if (this.getDownloadMethod() == 1) {
                                int rem = this.buffer.remaining();
                                buf = new byte[rem];
                                this.buffer.get(buf, 0, rem);
                                this.outputPipe.write(buf, 0, rem);
                                continue;
                            }
                            if (this.getDownloadMethod() == 2) continue;
                            channel.write(this.buffer);
                        }
                        this.buffer.clear();
                    }
                    this.buffer.flip();
                    while (this.buffer.hasRemaining()) {
                        if (this.getDownloadMethod() == 1) {
                            int rem = this.buffer.remaining();
                            buf = new byte[rem];
                            this.buffer.get(buf, 0, rem);
                            this.outputPipe.write(buf, 0, rem);
                            continue;
                        }
                        if (this.getDownloadMethod() == 2) continue;
                        channel.write(this.buffer);
                    }
                    this.buffer.clear();
                    this.setStatus(1);
                    if (channel != null) {
                        channel.close();
                    }
                    if (this.outputPipe != null) {
                        this.outputPipe.close();
                    }
                    this.getSocketProvider().close();
                    return;
                }
                catch (IOException ioe) {
                    this.setCaughtException(ioe);
                    this.setStatus(3);
                    return;
                }
                finally {
                    try {
                        channel.close();
                        this.getSocketProvider().close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (FileNotFoundException fnfe) {
                this.setCaughtException(fnfe);
                this.setStatus(2);
            }
            return;
        }
        if (!(this.getCommand() instanceof StoreCommand)) throw new IllegalArgumentException("Given command is not supported!");
        StoreCommand storeCommand = (StoreCommand)this.getCommand();
        if (storeCommand.getToFile().getTransferType().intern() != "TYPE I" && storeCommand.getToFile().getTransferType().intern() != "TYPE A") throw new IllegalArgumentException("Unknown file transfer type for upload!");
        try {
            log.debug((Object)("Upload file: " + storeCommand.getFromFile()));
            InputStream in = storeCommand.getStream();
            int socketAmount = 0;
            if (in instanceof FileInputStream) {
                FileChannel channel = ((FileInputStream)in).getChannel();
                if (storeCommand.getResumePosition() != -1L) {
                    try {
                        channel.position(storeCommand.getResumePosition());
                    }
                    catch (IOException ioe) {
                        this.setCaughtException(ioe);
                        this.setStatus(3);
                        try {
                            channel.close();
                            return;
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        return;
                    }
                }
                try {
                    int amount;
                    while ((amount = channel.read(this.buffer)) != -1) {
                        this.buffer.flip();
                        int socketWrite = 0;
                        while ((socketWrite = this.getSocketProvider().write(this.buffer)) != -1 && amount > (socketAmount += socketWrite)) {
                            if (socketWrite != 0) continue;
                            try {
                                Thread.sleep(4L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (socketWrite == -1) break;
                        socketAmount = 0;
                        this.buffer.clear();
                    }
                    this.setStatus(1);
                    channel.close();
                    this.getSocketProvider().close();
                    return;
                }
                catch (IOException ioe) {
                    this.setCaughtException(ioe);
                    this.setStatus(3);
                    return;
                }
                finally {
                    try {
                        channel.close();
                        this.getSocketProvider().close();
                    }
                    catch (Exception e) {}
                }
            }
            try {
                int amount;
                while ((amount = in.read(this.buffer.array())) != -1) {
                    this.buffer.flip();
                    this.buffer.limit(amount);
                    int socketWrite = 0;
                    while ((socketWrite = this.getSocketProvider().write(this.buffer)) != -1 && amount > (socketAmount = socketWrite)) {
                        if (socketWrite != 0) continue;
                        try {
                            Thread.sleep(4L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (socketWrite == -1) break;
                    socketAmount = 0;
                    this.buffer.clear();
                }
                this.setStatus(1);
                in.close();
                this.getSocketProvider().close();
                return;
            }
            catch (IOException ioe) {
                this.setCaughtException(ioe);
                this.setStatus(3);
                return;
            }
            finally {
                try {
                    in.close();
                    this.getSocketProvider().close();
                }
                catch (Exception e) {}
            }
        }
        catch (FileNotFoundException fnfe) {
            this.setCaughtException(fnfe);
            this.setStatus(2);
        }
    }

    public void setSocketProvider(SocketProvider socketProvider) {
        this.socketProvider = socketProvider;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public SocketProvider getSocketProvider() {
        return this.socketProvider;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Exception getCaughtException() {
        return this.caughtException;
    }

    public void setCaughtException(Exception caughtException) {
        this.caughtException = caughtException;
    }

    public Reply getReply() {
        return this.reply;
    }

    public void setReply(Reply reply) {
        this.reply = reply;
    }

    public void setInputPipe(PipedInputStream inputPipe) {
        this.inputPipe = inputPipe;
    }

    public void setDownloadBuffer(ByteBuffer downloadBuffer) {
        this.downloadBuffer = downloadBuffer;
    }

    public int getDownloadMethod() {
        return this.downloadMethod;
    }

    public void setDownloadMethod(int downloadMethod) {
        this.downloadMethod = downloadMethod;
    }
}

