/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet;

import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;
import org.pentaho.hadoop.shim.common.format.BaseFormatInputField;

public class ParquetInputField
extends BaseFormatInputField
implements IParquetInputField {
    public ParquetInputField() {
    }

    public ParquetInputField(String formatFieldName, ParquetSpec.DataType dataType, String pentahoFieldName, int pentahoType) {
        this.setFormatFieldName(formatFieldName);
        this.setParquetType(dataType);
        this.setPentahoFieldName(pentahoFieldName);
        this.setPentahoType(pentahoType);
    }

    public ParquetSpec.DataType getParquetType() {
        return ParquetSpec.DataType.getDataType((int)this.getFormatType());
    }

    public void setParquetType(ParquetSpec.DataType parquetType) {
        this.setFormatType(parquetType.getId());
    }

    public void setParquetType(String parquetType) {
        for (ParquetSpec.DataType tmpType : ParquetSpec.DataType.values()) {
            if (!tmpType.getName().equalsIgnoreCase(parquetType)) continue;
            this.setFormatType(tmpType.getId());
            break;
        }
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.getPentahoType());
    }

    private static String uc(String s) {
        if (s != null && s.isEmpty()) {
            return null;
        }
        return s;
    }

    public static IParquetInputField unmarshallField(String str) {
        String[] values = new String[7];
        int prev = 0;
        for (int i = 0; i < 6; ++i) {
            int pos = str.indexOf(124, prev);
            if (pos < 0) {
                throw new RuntimeException("Wrong field: " + str);
            }
            values[i] = str.substring(prev, pos);
            prev = pos + 1;
        }
        if (str.indexOf(124, prev) >= 0) {
            throw new RuntimeException("Wrong field: " + str);
        }
        values[6] = str.substring(prev);
        ParquetInputField field = new ParquetInputField();
        field.setFormatFieldName(ParquetInputField.uc(values[0]));
        field.setPentahoFieldName(ParquetInputField.uc(values[1]));
        field.setFormatType(Integer.parseInt(values[2]));
        field.setPentahoType(Integer.parseInt(values[3]));
        field.setPrecision(Integer.parseInt(values[4]));
        field.setScale(Integer.parseInt(values[5]));
        field.setStringFormat(values[6]);
        return field;
    }
}

