/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.orc.TypeDescription;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;
import org.pentaho.hadoop.shim.api.format.OrcSpec;
import org.pentaho.hadoop.shim.common.format.orc.OrcInputField;

public class OrcSchemaConverter {
    public TypeDescription buildTypeDescription(List<? extends IOrcOutputField> fields) {
        TypeDescription typeDescription = TypeDescription.createStruct();
        fields.forEach(field -> this.addStructField(typeDescription, (IOrcOutputField)field));
        return typeDescription;
    }

    private void addStructField(TypeDescription typeDescription, IOrcOutputField field) {
        typeDescription.addField(field.getFormatFieldName(), this.determineOrcType(field.getOrcType()));
    }

    private TypeDescription determineOrcType(OrcSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case TINYINT: {
                return TypeDescription.createByte();
            }
            case SMALLINT: {
                return TypeDescription.createShort();
            }
            case INTEGER: {
                return TypeDescription.createInt();
            }
            case BIGINT: {
                return TypeDescription.createLong();
            }
            case DATE: {
                return TypeDescription.createDate();
            }
            case BINARY: {
                return TypeDescription.createBinary();
            }
            case CHAR: {
                return TypeDescription.createChar();
            }
            case VARCHAR: {
                return TypeDescription.createVarchar();
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case DECIMAL: {
                return TypeDescription.createDecimal();
            }
            case TIMESTAMP: {
                return TypeDescription.createTimestamp();
            }
        }
        throw new RuntimeException("Attempted to write an unsupported Orc type: " + dataType.getName());
    }

    public List<IOrcInputField> buildInputFields(TypeDescription typeDescription) {
        ArrayList<IOrcInputField> inputFields = new ArrayList<IOrcInputField>();
        Iterator fieldNameIterator = typeDescription.getFieldNames().iterator();
        for (TypeDescription subDescription : typeDescription.getChildren()) {
            String fieldName = (String)fieldNameIterator.next();
            int formatType = this.determineFormatType(subDescription);
            if (formatType == -1) continue;
            int metaType = this.determineMetaType(subDescription);
            if (metaType == -1) {
                throw new IllegalStateException("Orc Field Name: " + fieldName + " - Could not find pdi field type for " + subDescription.getCategory().getName());
            }
            OrcInputField inputField = new OrcInputField();
            inputField.setFormatFieldName(fieldName);
            inputField.setFormatType(formatType);
            inputField.setPentahoType(metaType);
            inputField.setPentahoFieldName(fieldName);
            inputFields.add(inputField);
        }
        return inputFields;
    }

    private int determineMetaType(TypeDescription subDescription) {
        switch (subDescription.getCategory().getName()) {
            case "string": 
            case "char": 
            case "varchar": {
                return 2;
            }
            case "bigint": 
            case "tinyint": 
            case "smallint": 
            case "int": {
                return 5;
            }
            case "double": 
            case "float": {
                return 1;
            }
            case "decimal": {
                return 6;
            }
            case "timestamp": {
                return 9;
            }
            case "date": {
                return 3;
            }
            case "boolean": {
                return 4;
            }
            case "binary": {
                return 8;
            }
        }
        return -1;
    }

    private int determineFormatType(TypeDescription subDescription) {
        switch (subDescription.getCategory().getName()) {
            case "string": {
                return OrcSpec.DataType.STRING.getId();
            }
            case "char": {
                return OrcSpec.DataType.CHAR.getId();
            }
            case "varchar": {
                return OrcSpec.DataType.VARCHAR.getId();
            }
            case "bigint": {
                return OrcSpec.DataType.BIGINT.getId();
            }
            case "float": {
                return OrcSpec.DataType.FLOAT.getId();
            }
            case "double": {
                return OrcSpec.DataType.DOUBLE.getId();
            }
            case "decimal": {
                return OrcSpec.DataType.DECIMAL.getId();
            }
            case "timestamp": {
                return OrcSpec.DataType.TIMESTAMP.getId();
            }
            case "date": {
                return OrcSpec.DataType.DATE.getId();
            }
            case "boolean": {
                return OrcSpec.DataType.BOOLEAN.getId();
            }
            case "binary": {
                return OrcSpec.DataType.BINARY.getId();
            }
            case "int": {
                return OrcSpec.DataType.INTEGER.getId();
            }
            case "tinyint": {
                return OrcSpec.DataType.TINYINT.getId();
            }
            case "smallint": {
                return OrcSpec.DataType.SMALLINT.getId();
            }
        }
        return -1;
    }
}

