/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hbase.factory;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapred.Table10InputFormatDiscloser;
import org.pentaho.hadoop.hbase.factory.HBase10Admin;
import org.pentaho.hadoop.hbase.factory.HBase10Put;
import org.pentaho.hadoop.hbase.factory.HBase10Table;
import org.pentaho.hbase.factory.HBaseAdmin;
import org.pentaho.hbase.factory.HBaseClientFactory;
import org.pentaho.hbase.factory.HBaseClientFactoryLocator;
import org.pentaho.hbase.factory.HBasePut;
import org.pentaho.hbase.factory.HBaseTable;
import org.pentaho.hbase.mapred.PentahoTableInputFormat;
import org.pentaho.hbase.mapred.PentahoTableRecordReader;

public class HBase10ClientFactory
implements HBaseClientFactory {
    private Connection conn = null;
    private final Configuration conf;

    public HBase10ClientFactory(Configuration conf) throws Exception {
        this.conf = conf;
        this.conn = conf != null ? ConnectionFactory.createConnection((Configuration)conf) : null;
    }

    public synchronized Connection getConnection() throws IOException {
        if (this.conn == null) {
            this.conn = ConnectionFactory.createConnection((Configuration)this.conf);
        }
        return this.conn;
    }

    @Override
    public HBaseTable getHBaseTable(String tableName) {
        try {
            return new HBase10Table(this.getConnection(), tableName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HBaseAdmin getHBaseAdmin() {
        try {
            return new HBase10Admin(this.getConnection());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public HTableDescriptor getHBaseTableDescriptor(String tableName) {
        return new HTableDescriptor(TableName.valueOf((String)tableName));
    }

    @Override
    public HBaseTable wrap(Object tableObject) {
        if (tableObject == null) {
            throw new NullPointerException("null as a table was passed");
        }
        Table tab = null;
        if (tableObject instanceof Table) {
            tab = (Table)tableObject;
            return new HBase10Table(tab);
        }
        throw new IllegalArgumentException("Type mismatch:" + Table.class.getCanonicalName() + " was expected");
    }

    @Override
    public PentahoTableInputFormat getTableInputFormatImpl(final PentahoTableInputFormat common, Configuration conf) {
        return new PentahoTableInputFormat(){
            Table10InputFormatDiscloser invoker;
            {
                this.invoker = new Table10InputFormatDiscloser(common);
            }

            @Override
            protected void setHBaseTable(Configuration conf, String tableName) throws IOException {
                Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                this.invoker.initializeTable(conn, TableName.valueOf((String)tableName));
            }

            @Override
            protected boolean checkHBaseTable() {
                return this.invoker.getTable() != null;
            }

            @Override
            protected PentahoTableRecordReader createRecordReader(final Configuration config) {
                return new PentahoTableRecordReader(){

                    public void setHTable(Table table) {
                        HBaseClientFactory hbcf = HBaseClientFactoryLocator.getHBaseClientFactory(config);
                        this.getImpl().setHTable(hbcf.wrap(table));
                    }
                };
            }
        };
    }

    @Override
    public HBasePut getHBasePut(byte[] key) {
        return new HBase10Put(key);
    }
}

