/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.sla.SLASummaryBean;

public class SLASummaryGetForFilterJPAExecutor
implements JPAExecutor<List<SLASummaryBean>> {
    private static final String selectStr = "SELECT OBJECT(s) FROM SLASummaryBean s WHERE ";
    private SLASummaryFilter filter;
    private int numMaxResults;

    public SLASummaryGetForFilterJPAExecutor(SLASummaryFilter filter, int numMaxResults) {
        this.filter = filter;
        this.numMaxResults = numMaxResults;
    }

    @Override
    public String getName() {
        return "SLASummaryGetForFilterJPAExecutor";
    }

    @Override
    public List<SLASummaryBean> execute(EntityManager em) throws JPAExecutorException {
        List ssBean;
        StringBuilder sb = new StringBuilder(selectStr);
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        boolean firstCondition = true;
        if (this.filter.getJobId() != null) {
            firstCondition = false;
            if (this.filter.getParentId() != null) {
                sb.append("(s.jobId = :jobId OR s.parentId = :parentId)");
                queryParams.put("jobId", this.filter.getJobId());
                queryParams.put("parentId", this.filter.getParentId());
            } else {
                sb.append("s.jobId = :jobId");
                queryParams.put("jobId", this.filter.getJobId());
            }
        }
        if (this.filter.getParentId() != null && this.filter.getJobId() == null) {
            firstCondition = false;
            sb.append("s.parentId = :parentId");
            queryParams.put("parentId", this.filter.getParentId());
        }
        if (this.filter.getAppName() != null && this.filter.getJobId() == null && this.filter.getParentId() == null) {
            firstCondition = false;
            sb.append("s.appName = :appName");
            queryParams.put("appName", this.filter.getAppName());
        }
        if (this.filter.getNominalStart() != null) {
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            sb.append("s.nominalTimeTS >= :nominalTimeStart");
            queryParams.put("nominalTimeStart", new Timestamp(this.filter.getNominalStart().getTime()));
        }
        if (this.filter.getNominalEnd() != null) {
            if (firstCondition) {
                firstCondition = false;
            } else {
                sb.append(" AND ");
            }
            sb.append("s.nominalTimeTS <= :nominalTimeEnd");
            queryParams.put("nominalTimeEnd", new Timestamp(this.filter.getNominalEnd().getTime()));
        }
        if (this.filter.getEventStatus() != null) {
            this.processEventStatusFilter(this.filter, queryParams, sb, firstCondition);
        }
        sb.append(" ORDER BY s.nominalTimeTS");
        try {
            Query q = em.createQuery(sb.toString());
            for (Map.Entry entry : queryParams.entrySet()) {
                q.setParameter((String)entry.getKey(), entry.getValue());
            }
            q.setMaxResults(this.numMaxResults);
            ssBean = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return ssBean;
    }

    private void processEventStatusFilter(SLASummaryFilter filter, Map<String, Object> queryParams, StringBuilder sb, boolean firstCondition) {
        if (!firstCondition) {
            sb.append(" AND ");
        }
        List<SLAEvent.EventStatus> eventStatuses = filter.getEventStatus();
        int ind = 0;
        Timestamp currentTime = new Timestamp(new Date().getTime());
        if (eventStatuses.size() > 1) {
            sb.append("(");
        }
        for (SLAEvent.EventStatus status : eventStatuses) {
            if (ind > 0) {
                sb.append(" OR ");
            }
            if (status.equals((Object)SLAEvent.EventStatus.START_MET)) {
                sb.append("(s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NOT NULL ").append(" AND s.expectedStartTS >= s.actualStartTS)");
            } else if (status.equals((Object)SLAEvent.EventStatus.START_MISS)) {
                sb.append("((s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NOT NULL ").append(" AND s.expectedStartTS <= s.actualStartTS) ").append("OR (s.expectedStartTS IS NOT NULL AND s.actualStartTS IS NULL ").append(" AND s.expectedStartTS <= :currentTimeStamp))");
                queryParams.put("currentTimeStamp", currentTime);
            } else if (status.equals((Object)SLAEvent.EventStatus.DURATION_MET)) {
                sb.append("(s.expectedDuration <> -1 AND s.actualDuration <> -1 ").append(" AND s.expectedDuration >= s.actualDuration) ");
            } else if (status.equals((Object)SLAEvent.EventStatus.DURATION_MISS)) {
                sb.append("((s.expectedDuration <> -1 AND s.actualDuration <> -1 ").append("AND s.expectedDuration < s.actualDuration) ").append("OR s.eventStatus = 'DURATION_MISS')");
            } else if (status.equals((Object)SLAEvent.EventStatus.END_MET)) {
                sb.append("(s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NOT NULL ").append(" AND s.expectedEndTS <= s.actualEndTS) ");
            } else if (status.equals((Object)SLAEvent.EventStatus.END_MISS)) {
                sb.append("((s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NOT NULL ").append("AND s.expectedEndTS <= s.actualEndTS) ").append("OR (s.expectedEndTS IS NOT NULL AND s.actualEndTS IS NULL ").append("AND s.expectedEndTS <= :currentTimeStamp))");
                queryParams.put("currentTimeStamp", currentTime);
            }
            ++ind;
        }
        if (eventStatuses.size() > 1) {
            sb.append(")");
        }
    }

    public static class SLASummaryFilter {
        private String appName;
        private String jobId;
        private String parentId;
        private List<SLAEvent.EventStatus> eventStatus;
        private Date nominalStart;
        private Date nominalEnd;

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public Date getNominalStart() {
            return this.nominalStart;
        }

        public void setNominalStart(Date nominalStart) {
            this.nominalStart = nominalStart;
        }

        public Date getNominalEnd() {
            return this.nominalEnd;
        }

        public void setNominalEnd(Date nominalEnd) {
            this.nominalEnd = nominalEnd;
        }

        public List<SLAEvent.EventStatus> getEventStatus() {
            return this.eventStatus;
        }

        public void setEventStatus(String eventStatus) {
            if (this.eventStatus == null) {
                this.eventStatus = new ArrayList<SLAEvent.EventStatus>();
            }
            if (eventStatus.equalsIgnoreCase("ALL")) {
                this.eventStatus.addAll(Arrays.asList(SLAEvent.EventStatus.values()));
            } else {
                String[] eventStatuses;
                for (String es : eventStatuses = eventStatus.split(",")) {
                    this.eventStatus.add(SLAEvent.EventStatus.valueOf((String)es));
                }
            }
        }
    }
}

