/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionGetJPAExecutor
implements JPAExecutor<WorkflowActionBean> {
    private String wfActionId = null;

    public WorkflowActionGetJPAExecutor(String wfActionId) {
        ParamChecker.notNull(wfActionId, "wfActionId");
        this.wfActionId = wfActionId;
    }

    @Override
    public String getName() {
        return "WorkflowActionGetJPAExecutor";
    }

    @Override
    public WorkflowActionBean execute(EntityManager em) throws JPAExecutorException {
        List waBeans;
        try {
            Query q = em.createNamedQuery("GET_ACTION");
            q.setParameter("id", (Object)this.wfActionId);
            waBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        WorkflowActionBean bean = null;
        if (waBeans != null && waBeans.size() > 0) {
            bean = (WorkflowActionBean)waBeans.get(0);
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0605, this.wfActionId);
    }
}

