/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsGetReadyGroupbyJobIDJPAExecutor
implements JPAExecutor<List<String>> {
    private long checkAgeSecs = 0L;

    public CoordActionsGetReadyGroupbyJobIDJPAExecutor(long checkAgeSecs) {
        ParamChecker.notNull(checkAgeSecs, "checkAgeSecs");
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public String getName() {
        return "CoordActionsGetReadyGroupbyJobIDJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<String> jobids = new ArrayList<String>();
        try {
            Query q = em.createNamedQuery("GET_READY_ACTIONS_GROUP_BY_JOBID");
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            q.setParameter("lastModifiedTime", (Object)ts);
            List list = q.getResultList();
            for (Object[] arr : list) {
                if (arr == null || arr[0] == null) continue;
                jobids.add((String)arr[0]);
            }
            return jobids;
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
    }
}

