/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleActionGetJPAExecutor
implements JPAExecutor<BundleActionBean> {
    private String bundleActionId = null;

    public BundleActionGetJPAExecutor(String bundleId, String coordName) {
        ParamChecker.notNull(bundleId, "bundleId");
        ParamChecker.notNull(coordName, "coordName");
        this.bundleActionId = bundleId + "_" + coordName;
    }

    @Override
    public String getName() {
        return "BundleActionGetJPAExecutor";
    }

    @Override
    public BundleActionBean execute(EntityManager em) throws JPAExecutorException {
        List baBeans;
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_ACTION");
            q.setParameter("bundleActionId", (Object)this.bundleActionId);
            baBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        BundleActionBean bean = null;
        if (baBeans != null && baBeans.size() > 0) {
            bean = (BundleActionBean)baBeans.get(0);
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0605, this.bundleActionId);
    }
}

