/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowInstance;
import org.json.simple.JSONValue;

public class HadoopELFunctions {
    private static final String HADOOP_COUNTERS = "oozie.el.action.hadoop.counters";
    public static final String RECORDS = "org.apache.hadoop.mapred.Task$Counter";
    public static final String MAP_IN = "MAP_INPUT_RECORDS";
    public static final String MAP_OUT = "MAP_OUTPUT_RECORDS";
    public static final String REDUCE_IN = "REDUCE_INPUT_RECORDS";
    public static final String REDUCE_OUT = "REDUCE_OUTPUT_RECORDS";
    public static final String GROUPS = "REDUCE_INPUT_GROUPS";
    private static final String RECORDS_023 = "org.apache.hadoop.mapreduce.TaskCounter";

    public static Map<String, Map<String, Long>> hadoop_counters(String nodeName) throws ELEvaluationException {
        WorkflowInstance instance = DagELFunctions.getWorkflow().getWorkflowInstance();
        Object obj = instance.getTransientVar(nodeName + "#" + HADOOP_COUNTERS);
        Map<String, Map<String, Long>> counters = (Map<String, Map<String, Long>>)obj;
        if (counters == null) {
            counters = HadoopELFunctions.getCounters(nodeName);
            if (counters.get(RECORDS) == null) {
                counters.put(RECORDS, counters.get(RECORDS_023));
            }
            instance.setTransientVar(nodeName + "#" + HADOOP_COUNTERS, counters);
        }
        return counters;
    }

    public static String hadoop_conf(String hadoopConfHostPort, String propName) {
        JobConf conf = Services.get().get(HadoopAccessorService.class).createJobConf(hadoopConfHostPort);
        String prop = conf.get(propName);
        if (prop == null || prop.equals("")) {
            conf = new Configuration();
            prop = conf.get(propName);
        }
        if (prop == null) {
            prop = "";
        }
        return prop;
    }

    private static Map<String, Map<String, Long>> getCounters(String nodeName) throws ELEvaluationException {
        String jsonCounters = DagELFunctions.getActionVar(nodeName, "hadoop.counters");
        if (jsonCounters == null) {
            throw new IllegalArgumentException(XLog.format("Hadoop counters not available for action [{0}]", nodeName));
        }
        return (Map)JSONValue.parse((String)jsonCounters);
    }
}

