/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.staging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.platform.plugin.TrackingOutputStream;
import org.pentaho.reporting.platform.plugin.staging.AbstractStagingHandler;

public class MemStagingHandler
extends AbstractStagingHandler {
    private static final Log logger = LogFactory.getLog(MemStagingHandler.class);
    TrackingOutputStream memoryTrackingStream;

    public MemStagingHandler(OutputStream outputStream, IPentahoSession userSession) throws IOException {
        super(outputStream, userSession);
    }

    @Override
    protected void initialize() throws IOException {
        logger.trace((Object)"Staging mode set - MEM");
        this.memoryTrackingStream = new TrackingOutputStream((OutputStream)new MemoryByteArrayOutputStream());
    }

    @Override
    public void complete() throws IOException {
        MemoryByteArrayOutputStream stream = (MemoryByteArrayOutputStream)this.memoryTrackingStream.getWrappedStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stream.getRaw());
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
    }

    @Override
    public void close() {
        if (this.memoryTrackingStream != null) {
            try {
                this.memoryTrackingStream.close();
            }
            catch (IOException e) {
                logger.debug((Object)"Unable to close memory stream? (never happens)");
            }
        }
    }

    @Override
    public int getWrittenByteCount() {
        return this.memoryTrackingStream.getTrackingSize();
    }

    @Override
    public boolean canSendHeaders() {
        return true;
    }

    @Override
    public OutputStream getStagingOutputStream() {
        return this.memoryTrackingStream;
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public StagingMode getStagingMode() {
        return StagingMode.MEMORY;
    }
}

