/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.staging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.platform.plugin.staging.IFixedSizeStreamingContent;

public class AsyncJobFileStagingHandler {
    public static final String POSTFIX = ".tmp";
    public static final String STAGING_DIR_ATTR = "asyncstaging";
    private static final Log logger = LogFactory.getLog(AsyncJobFileStagingHandler.class);
    private String sessionId;
    private OutputStream fileTrackingStream;
    File tmpFile;
    private String stringParentDir = null;

    public AsyncJobFileStagingHandler(IPentahoSession userSession) throws IOException {
        this.sessionId = userSession.getId();
        IApplicationContext context = PentahoSystem.getApplicationContext();
        this.stringParentDir = context == null ? null : context.getSolutionPath("system/tmp");
        this.initialize();
    }

    protected void initialize() throws IOException {
        logger.trace((Object)"Staging mode set - TEMP_FILE, async report generation");
        if (this.stringParentDir == null) {
            throw new IOException("can't find system/tmp dir, asycn staging not possible.");
        }
        Path stagingExecutionFolder = this.getStagingExecutionFolder(this.sessionId);
        if (!stagingExecutionFolder.toFile().exists() && !stagingExecutionFolder.toFile().mkdirs()) {
            throw new IOException("Unable to create staging async directory");
        }
        Path tempFilePath = stagingExecutionFolder.resolve(UUIDUtil.getUUIDAsString() + POSTFIX);
        this.tmpFile = tempFilePath.toFile();
        IPentahoSession session = PentahoSessionHolder.getSession();
        ITempFileDeleter deleter = null;
        if (session != null) {
            deleter = (ITempFileDeleter)session.getAttribute("PENTAHO_TMP_DELETER");
        }
        if (deleter != null) {
            deleter.trackTempFile(this.tmpFile);
        } else {
            this.tmpFile.deleteOnExit();
        }
        this.fileTrackingStream = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
    }

    private Path getStagingExecutionFolder(String userSession) {
        return AsyncJobFileStagingHandler.getStagingDirPath().resolve(userSession);
    }

    public static Path getStagingDirPath() {
        IApplicationContext context = PentahoSystem.getApplicationContext();
        String solutionTempFolder = context == null ? null : context.getSolutionPath("system/tmp");
        return solutionTempFolder == null ? null : Paths.get(solutionTempFolder, new String[0]).resolve(STAGING_DIR_ATTR);
    }

    public OutputStream getStagingOutputStream() {
        return this.fileTrackingStream;
    }

    public IFixedSizeStreamingContent getStagingContent() throws FileNotFoundException {
        return new FixedSizeStagingContent(this.tmpFile);
    }

    public static void cleanSession(IPentahoSession session) {
        ArgumentNullException.validate((String)"session", (Object)session);
        AsyncJobFileStagingHandler.cleanSession(session.getId());
    }

    public static void cleanSession(String sessionId) {
        Path stagingSessionDir = AsyncJobFileStagingHandler.getStagingDirPath();
        if (stagingSessionDir == null) {
            return;
        }
        stagingSessionDir = stagingSessionDir.resolve(sessionId);
        File sessionStagingContent = stagingSessionDir.toFile();
        try {
            if (sessionStagingContent != null && sessionStagingContent.isDirectory() && sessionStagingContent.list().length == 0) {
                FileUtils.deleteDirectory((File)sessionStagingContent);
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Unable delete temp files on session logout.");
        }
    }

    public static void cleanStagingDir() {
        Path stagingDir = AsyncJobFileStagingHandler.getStagingDirPath();
        if (stagingDir != null) {
            File stagingDirFile = stagingDir.toFile();
            try {
                FileUtils.deleteDirectory((File)stagingDirFile);
            }
            catch (IOException e) {
                logger.debug((Object)("Unable to delete async staging content on shutdown. Directory: " + stagingDirFile.getName()), (Throwable)e);
            }
        }
    }

    public static final class FixedSizeStagingContent
    implements IFixedSizeStreamingContent {
        private InputStream in;
        private long size;
        File tmpFile;

        public FixedSizeStagingContent(File tmpFile) {
            this.size = tmpFile.length();
            this.tmpFile = tmpFile;
        }

        @Override
        public InputStream getStream() {
            FileInputStream stagingInputStream = null;
            try {
                stagingInputStream = new FileInputStream(this.tmpFile);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("staging file not found: " + this.tmpFile.toPath().toString()));
            }
            return stagingInputStream;
        }

        @Override
        public long getContentSize() {
            return this.size;
        }

        @Override
        public boolean cleanContent() {
            return this.tmpFile.delete();
        }
    }
}

