/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.repository;

import java.io.File;
import java.io.IOException;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.file.FileContentLocation;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;

public class TempDirectoryNameGenerator
implements PentahoNameGenerator {
    private File targetDirectory;
    private MimeRegistry mimeRegistry;
    private DefaultNameGenerator fallback;
    private boolean safeToDelete;

    @Override
    public void initialize(ContentLocation contentLocation, boolean safeToDelete) {
        this.safeToDelete = safeToDelete;
        this.mimeRegistry = contentLocation.getRepository().getMimeRegistry();
        if (contentLocation instanceof FileContentLocation) {
            FileContentLocation fileContentLocation = (FileContentLocation)contentLocation;
            this.targetDirectory = (File)fileContentLocation.getContentId();
            if (!this.targetDirectory.isDirectory()) {
                throw new NullPointerException();
            }
        }
        if (this.targetDirectory == null) {
            this.fallback = new DefaultNameGenerator(contentLocation);
        }
    }

    public String generateName(String nameHint, String mimeType) throws ContentIOException {
        if (this.fallback != null) {
            return this.fallback.generateName(nameHint, mimeType);
        }
        String suffix = this.mimeRegistry.getSuffix(mimeType);
        try {
            IApplicationContext appCtx = PentahoSystem.getApplicationContext();
            IPentahoSession userSession = PentahoSessionHolder.getSession();
            File tempFile = appCtx.createTempFile(userSession, nameHint, "." + suffix, this.safeToDelete);
            return tempFile.getName();
        }
        catch (IOException e) {
            throw new ContentIOException("Unable to generate a name for the data file", (Exception)e);
        }
    }
}

