/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class XLSOutput
implements ReportOutputHandler {
    private byte[] templateData;
    private ProxyOutputStream proxyOutputStream;

    public void setTemplateDataFromStream(InputStream templateInputStream) throws IOException {
        if (templateInputStream != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                IOUtils.getInstance().copyStreams(templateInputStream, (OutputStream)bout);
            }
            finally {
                templateInputStream.close();
            }
            this.templateData = bout.toByteArray();
        } else {
            this.templateData = null;
        }
    }

    public byte[] getTemplateData() {
        return this.templateData;
    }

    public void setTemplateData(byte[] templateData) {
        this.templateData = templateData;
    }

    @Override
    public Object getReportLock() {
        return this;
    }

    private FlowReportProcessor createProcessor(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(report.getConfiguration(), (OutputStream)this.proxyOutputStream, report.getResourceManager());
        target.setUseXlsxFormat(false);
        FlowReportProcessor reportProcessor = new FlowReportProcessor(report, (OutputProcessor)target);
        if (yieldRate > 0) {
            reportProcessor.addReportProgressListener((ReportProgressListener)this.getYieldListener(yieldRate));
        }
        return reportProcessor;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException {
        FlowReportProcessor reportProcessor = this.createProcessor(report, yieldRate);
        IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
        if (listener != null) {
            reportProcessor.addReportProgressListener((ReportProgressListener)listener);
        }
        try {
            this.proxyOutputStream.setParent(outputStream);
            if (this.templateData != null) {
                FlowExcelOutputProcessor target = (FlowExcelOutputProcessor)reportProcessor.getOutputProcessor();
                target.setTemplateInputStream((InputStream)new ByteArrayInputStream(this.templateData));
            }
            reportProcessor.processReport();
            if (listener != null) {
                listener.setIsQueryLimitReached(reportProcessor.isQueryLimitReached());
            }
            outputStream.flush();
            int n = 0;
            return n;
        }
        finally {
            if (listener != null) {
                reportProcessor.removeReportProgressListener((ReportProgressListener)listener);
            }
            reportProcessor.close();
            this.proxyOutputStream.setParent(null);
            FlowExcelOutputProcessor target = (FlowExcelOutputProcessor)reportProcessor.getOutputProcessor();
            target.setTemplateInputStream(null);
        }
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
    }
}

