/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.output.AbstractHtmlOutput;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;
import org.pentaho.reporting.platform.plugin.repository.PentahoURLRewriter;
import org.pentaho.reporting.platform.plugin.repository.ReportContentRepository;

public class StreamJcrHtmlOutput
extends AbstractHtmlOutput {
    private String jcrOutputPath;

    public StreamJcrHtmlOutput() {
    }

    public StreamJcrHtmlOutput(String contentHandlerPattern, String jcrOutputPath) {
        super(contentHandlerPattern);
        this.jcrOutputPath = jcrOutputPath;
    }

    public String getJcrOutputPath() {
        return this.jcrOutputPath;
    }

    public void setJcrOutputPath(String jcrOutputPath) {
        this.jcrOutputPath = jcrOutputPath;
    }

    @Override
    protected FastHtmlContentItems computeContentItems(OutputStream outputStream) throws ReportProcessingException, ContentIOException {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile outputFolder = repo.getFile(this.jcrOutputPath);
        ReportContentRepository repository = new ReportContentRepository(outputFolder);
        ContentLocation dataLocation = repository.getRoot();
        PentahoNameGenerator dataNameGenerator = this.createPentahoNameGenerator();
        dataNameGenerator.initialize(dataLocation, this.isSafeToDelete());
        StreamRepository targetRepository = new StreamRepository(null, outputStream, "report");
        ContentLocation targetRoot = targetRepository.getRoot();
        FastHtmlContentItems contentItems = new FastHtmlContentItems();
        contentItems.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        contentItems.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
        contentItems.setUrlRewriter((URLRewriter)new PentahoURLRewriter(this.getContentHandlerPattern(), true));
        return contentItems;
    }

    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        FastHtmlContentItems contentItems = this.computeContentItems(outputStream);
        AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
        printer.setContentWriter(contentItems.getContentLocation(), contentItems.getContentNameGenerator());
        printer.setDataWriter(contentItems.getDataLocation(), contentItems.getDataNameGenerator());
        printer.setUrlRewriter(contentItems.getUrlRewriter());
        StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(report.getConfiguration());
        outputProcessor.setPrinter((HtmlPrinter)printer);
        StreamReportProcessor sp = new StreamReportProcessor(report, (OutputProcessor)outputProcessor);
        IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
        this.doProcess(listener, (AbstractReportProcessor)sp);
        outputStream.flush();
        return 0;
    }
}

