/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import mondrian.util.Pair;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.SinglePageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.PageableHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.PageSequenceNameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;
import org.pentaho.reporting.platform.plugin.PentahoPlatformModule;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.cache.IReportContent;
import org.pentaho.reporting.platform.plugin.cache.ReportContentImpl;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.AbstractHtmlOutput;
import org.pentaho.reporting.platform.plugin.output.PaginationControlWrapper;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;
import org.pentaho.reporting.platform.plugin.repository.PentahoURLRewriter;

public class PageableHTMLOutput
extends AbstractHtmlOutput {
    private ProxyOutputStream proxyOutputStream;
    private PageableReportProcessor proc;
    private AllItemsHtmlPrinter printer;

    @Override
    public Object getReportLock() {
        return this;
    }

    public ProxyOutputStream getProxyOutputStream() {
        return this.proxyOutputStream;
    }

    public void setProxyOutputStream(ProxyOutputStream proxyOutputStream) {
        this.proxyOutputStream = proxyOutputStream;
    }

    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(AllItemsHtmlPrinter printer) {
        this.printer = printer;
    }

    public PageableReportProcessor getReportProcessor() {
        return this.proc;
    }

    public void setReportProcessor(PageableReportProcessor proc) {
        this.proc = proc;
    }

    protected PageableReportProcessor createReportProcessor(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        this.printer = new AllItemsHtmlPrinter(report.getResourceManager());
        this.printer.setUrlRewriter((URLRewriter)new PentahoURLRewriter(this.getContentHandlerPattern(), this.shouldUseContentIdAsName()));
        PageableHtmlOutputProcessor outputProcessor = new PageableHtmlOutputProcessor(report.getConfiguration());
        outputProcessor.setPrinter((HtmlPrinter)this.printer);
        this.proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
        if (yieldRate > 0) {
            this.proc.addReportProgressListener((ReportProgressListener)this.getYieldListener(yieldRate));
        }
        return this.proc;
    }

    protected boolean shouldUseContentIdAsName() {
        return false;
    }

    protected void reinitOutputTarget() throws ReportProcessingException, ContentIOException {
        Pair<ContentLocation, PentahoNameGenerator> pair = this.reinitLocationAndNameGenerator();
        StreamRepository targetRepository = new StreamRepository(null, (OutputStream)this.proxyOutputStream, "report");
        ContentLocation targetRoot = targetRepository.getRoot();
        this.printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        this.printer.setDataWriter((ContentLocation)pair.getKey(), (NameGenerator)pair.getValue());
    }

    protected Pair<ContentLocation, PentahoNameGenerator> reinitLocationAndNameGenerator() throws ReportProcessingException, ContentIOException {
        PentahoNameGenerator dataNameGenerator;
        ContentLocation dataLocation;
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx != null) {
            File dataDirectory = new File(ctx.getFileOutputPath("system/tmp/"));
            if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                    throw new ReportProcessingException("Dead " + dataDirectory.getPath());
                }
            } else if (!dataDirectory.exists()) {
                dataDirectory.mkdirs();
            }
            FileRepository dataRepository = new FileRepository(dataDirectory);
            dataLocation = dataRepository.getRoot();
            dataNameGenerator = (PentahoNameGenerator)PentahoSystem.get(PentahoNameGenerator.class);
            if (dataNameGenerator == null) {
                throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorNameGeneratorMissingConfiguration"));
            }
            dataNameGenerator.initialize(dataLocation, true);
        } else {
            dataLocation = null;
            dataNameGenerator = null;
        }
        return Pair.of(dataLocation, dataNameGenerator);
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        if (this.proc == null) {
            this.proc = this.createReportProcessor(report, yieldRate);
        }
        this.reinitOutputTarget();
        try {
            if (!this.proc.isPaginated()) {
                this.proc.paginate();
            }
        }
        finally {
            this.printer.setContentWriter(null, null);
            this.printer.setDataWriter(null, null);
        }
        return this.proc.getLogicalPageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        boolean asyncMode;
        if (this.proc == null) {
            this.proc = this.createReportProcessor(report, yieldRate);
        }
        boolean singlePageRequested = acceptedPage >= 0;
        IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
        boolean bl = asyncMode = listener != null;
        if (asyncMode) {
            this.proc.addReportProgressListener((ReportProgressListener)listener);
        }
        PageableHtmlOutputProcessor outputProcessor = (PageableHtmlOutputProcessor)this.proc.getOutputProcessor();
        if (singlePageRequested && !asyncMode) {
            outputProcessor.setFlowSelector((FlowSelector)new SinglePageFlowSelector(acceptedPage));
        } else {
            outputProcessor.setFlowSelector((FlowSelector)new DisplayAllFlowSelector());
        }
        try {
            boolean forceAllPages;
            if (!asyncMode || !singlePageRequested) {
                this.proxyOutputStream.setParent(outputStream);
                this.reinitOutputTarget();
                this.proc.processReport();
                if (listener != null) {
                    listener.setIsQueryLimitReached(this.proc.isQueryLimitReached());
                }
                int n = this.proc.getLogicalPageCount();
                return n;
            }
            Repository repository = this.reinitOutputTargetRepo();
            this.proc.processReport();
            IReportContent completeReport = this.produceReportContent(this.proc, repository);
            if (completeReport == null) {
                throw new ReportProcessingException("Can't generate report");
            }
            if (listener != null) {
                listener.setIsQueryLimitReached(this.proc.isQueryLimitReached());
            }
            if ((forceAllPages = this.isForceAllPages(report)) || listener.isScheduled()) {
                PaginationControlWrapper.write(outputStream, completeReport);
            } else {
                byte[] pageData = completeReport.getPageData(acceptedPage);
                if (pageData != null) {
                    outputStream.write(pageData);
                }
            }
            int n = completeReport.getPageCount();
            return n;
        }
        finally {
            if (asyncMode) {
                this.proc.removeReportProgressListener((ReportProgressListener)listener);
            }
            outputStream.flush();
            this.printer.setContentWriter(null, null);
            this.printer.setDataWriter(null, null);
        }
    }

    protected boolean isForceAllPages(MasterReport report) {
        return "true".equals(report.getConfiguration().getConfigProperty(PentahoPlatformModule.FORCE_ALL_PAGES));
    }

    @Override
    public boolean supportsPagination() {
        return true;
    }

    @Override
    public void close() {
        if (this.proc != null) {
            this.proc.close();
            this.proxyOutputStream = null;
        }
    }

    protected Repository reinitOutputTargetRepo() throws ReportProcessingException, ContentIOException {
        Pair<ContentLocation, PentahoNameGenerator> pair = this.reinitLocationAndNameGenerator();
        ZipRepository targetRepository = new ZipRepository();
        ContentLocation targetRoot = targetRepository.getRoot();
        HtmlPrinter printer = this.getPrinter();
        printer.setContentWriter(targetRoot, (NameGenerator)new PageSequenceNameGenerator(targetRoot, "page", "html"));
        printer.setDataWriter((ContentLocation)pair.getKey(), (NameGenerator)pair.getValue());
        return targetRepository;
    }

    private int extractPageFromName(String name) {
        if (name.startsWith("page-") && name.endsWith(".html")) {
            try {
                String number = name.substring("page-".length(), name.length() - ".html".length());
                return Integer.parseInt(number);
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    protected IReportContent produceReportContent(PageableReportProcessor proc, Repository targetRepository) throws ContentIOException, IOException {
        int pageCount = proc.getLogicalPageCount();
        ContentLocation root = targetRepository.getRoot();
        HashMap<Integer, byte[]> pages = new HashMap<Integer, byte[]>();
        for (ContentEntity contentEntities : root.listContents()) {
            ContentItem ci;
            String name;
            int pageNumber;
            if (!(contentEntities instanceof ContentItem) || (pageNumber = this.extractPageFromName(name = (ci = (ContentItem)contentEntities).getName())) < 0) continue;
            pages.put(pageNumber, this.read(ci.getInputStream()));
        }
        return new ReportContentImpl(pageCount, pages);
    }

    private byte[] read(InputStream in) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            in.close();
        }
    }
}

