/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportProcessor;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.XLSOutput;

public class FastXLSOutput
extends XLSOutput {
    private ProxyOutputStream proxyOutputStream = new ProxyOutputStream();

    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException {
        this.proxyOutputStream.setParent(outputStream);
        IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
        ReportStructureValidator validator = new ReportStructureValidator();
        if (!validator.isValidForFastProcessing(report)) {
            return super.generate(report, acceptedPage, outputStream, yieldRate);
        }
        FastExcelExportProcessor reportProcessor = new FastExcelExportProcessor(report, outputStream, false);
        this.doProcess(listener, (AbstractReportProcessor)reportProcessor);
        outputStream.flush();
        return 0;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public Object getReportLock() {
        return this;
    }
}

