/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailURLRewriter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class EmailOutput
implements ReportOutputHandler {
    private static final String ROTATED_TEXT_AS_IMAGES = "org.pentaho.reporting.engine.classic.core.modules.output.table.html.RotatedTextAsImages";

    @Override
    public Object getReportLock() {
        return this;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx == null) {
            return -1;
        }
        try {
            Configuration configuration = report.getConfiguration();
            if (configuration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modifiableConfiguration = (ModifiableConfiguration)configuration;
                modifiableConfiguration.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.InlineStyles", "true");
                modifiableConfiguration.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ExternalStyle", "false");
                modifiableConfiguration.setConfigProperty(ROTATED_TEXT_AS_IMAGES, "true");
            }
            Properties props = new Properties();
            Session session = Session.getInstance((Properties)props);
            EmailRepository dataRepository = new EmailRepository(session);
            ContentLocation dataLocation = dataRepository.getRoot();
            StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(configuration);
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(dataLocation, (NameGenerator)new DefaultNameGenerator(dataLocation, "index", "html"));
            printer.setDataWriter(dataLocation, (NameGenerator)new DefaultNameGenerator(dataLocation));
            printer.setUrlRewriter((URLRewriter)new MailURLRewriter());
            outputProcessor.setPrinter((HtmlPrinter)printer);
            StreamReportProcessor sp = new StreamReportProcessor(report, (OutputProcessor)outputProcessor);
            if (yieldRate > 0) {
                sp.addReportProgressListener((ReportProgressListener)this.getYieldListener(yieldRate));
            }
            IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
            this.doProcess(listener, (AbstractReportProcessor)sp);
            dataRepository.writeEmail(outputStream);
            outputStream.flush();
            return 0;
        }
        catch (MessagingException e) {
            throw new ReportProcessingException("Error", (Exception)((Object)e));
        }
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
    }
}

