/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.PageableHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.Base64;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.cache.IPluginCacheManager;
import org.pentaho.reporting.platform.plugin.cache.IReportContent;
import org.pentaho.reporting.platform.plugin.cache.IReportContentCache;
import org.pentaho.reporting.platform.plugin.output.PageableHTMLOutput;
import org.pentaho.reporting.platform.plugin.output.PaginationControlWrapper;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;
import org.pentaho.reporting.platform.plugin.repository.ReportContentRepository;

public class CachingPageableHTMLOutput
extends PageableHTMLOutput {
    private static Log logger = LogFactory.getLog(CachingPageableHTMLOutput.class);
    public static final String IS_QUERY_LIMIT_REACHED = "IsQueryLimitReached";
    public static final String REPORT_ROWS = "ReportRows";
    private PageableReportProcessor processor;
    private String jcrOutputPath;

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        try {
            IReportContent cachedContent;
            String key = report.getContentCacheKey();
            if (key == null) {
                key = this.createKey(report);
            }
            if ((cachedContent = this.getCachedContent(key)) != null) {
                return cachedContent.getPageCount();
            }
            IReportContent freshCache = this.regenerateCache(report, yieldRate, key, 0);
            return freshCache.getPageCount();
        }
        catch (CacheKeyException e) {
            return super.paginate(report, yieldRate);
        }
    }

    @Override
    public synchronized int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        if (acceptedPage < 0) {
            return this.generateNonCaching(report, acceptedPage, outputStream, yieldRate);
        }
        try {
            String key = report.getContentCacheKey();
            if (key == null) {
                key = this.createKey(report);
            }
            IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
            IReportContent cachedContent = this.getCachedContent(key);
            boolean forcePaginated = this.isForceAllPages(report);
            if (cachedContent == null || listener != null && listener.isScheduled() && cachedContent.getPageCount() != cachedContent.getStoredPageCount()) {
                logger.warn((Object)("No cached content found for key: " + key));
                IReportContent freshCache = this.regenerateCache(report, yieldRate, key, acceptedPage);
                if (freshCache != null) {
                    if (forcePaginated || listener != null && listener.isScheduled()) {
                        PaginationControlWrapper.write(outputStream, freshCache);
                        return freshCache.getPageCount();
                    }
                    this.setQueryLimitReachedToListener(key, listener);
                    byte[] pageData = freshCache.getPageData(acceptedPage);
                    outputStream.write(pageData);
                    outputStream.flush();
                    return freshCache.getPageCount();
                }
                return -1;
            }
            this.setQueryLimitReachedToListener(key, listener);
            byte[] page = cachedContent.getPageData(acceptedPage);
            if (page != null && page.length > 0) {
                logger.warn((Object)("Using cached report data for " + key));
                if (listener != null) {
                    listener.updateGenerationStatus(cachedContent.getStoredPageCount());
                    ReportProgressEvent event = new ReportProgressEvent((Object)this, 3, 0, this.getReportTotalRows(key), acceptedPage + 1, cachedContent.getPageCount(), 0, 0);
                    listener.reportProcessingUpdate(event);
                    listener.reportProcessingFinished(event);
                }
                if (forcePaginated || listener != null && listener.isScheduled()) {
                    PaginationControlWrapper.write(outputStream, cachedContent);
                    return cachedContent.getPageCount();
                }
                outputStream.write(page);
                outputStream.flush();
                return cachedContent.getPageCount();
            }
            IReportContent fullReportCache = this.regenerateCache(report, yieldRate, key, acceptedPage);
            if (forcePaginated || listener != null && listener.isScheduled()) {
                PaginationControlWrapper.write(outputStream, fullReportCache);
                return fullReportCache.getPageCount();
            }
            outputStream.write(fullReportCache.getPageData(acceptedPage));
            outputStream.flush();
            return fullReportCache.getPageCount();
        }
        catch (CacheKeyException e) {
            return this.generateNonCaching(report, acceptedPage, outputStream, yieldRate);
        }
    }

    protected boolean isJcrImagesAndCss() {
        return this.getJcrOutputPath() != null && !this.getJcrOutputPath().isEmpty();
    }

    @Override
    protected Pair<ContentLocation, PentahoNameGenerator> reinitLocationAndNameGenerator() throws ReportProcessingException, ContentIOException {
        if (!this.isJcrImagesAndCss()) {
            return super.reinitLocationAndNameGenerator();
        }
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile outputFolder = repo.getFile(this.jcrOutputPath);
        ReportContentRepository repository = new ReportContentRepository(outputFolder);
        ContentLocation dataLocation = repository.getRoot();
        PentahoNameGenerator dataNameGenerator = this.createPentahoNameGenerator();
        dataNameGenerator.initialize(dataLocation, this.isSafeToDelete());
        return Pair.of((Object)dataLocation, (Object)dataNameGenerator);
    }

    @Override
    protected boolean shouldUseContentIdAsName() {
        return this.isJcrImagesAndCss();
    }

    private void setQueryLimitReachedToListener(String key, IAsyncReportListener listener) {
        Serializable isQueryLimitReached;
        Map<String, Serializable> metaData = this.getCachedMetaData(key);
        if (metaData != null && listener != null && (isQueryLimitReached = metaData.get(IS_QUERY_LIMIT_REACHED)) != null) {
            listener.setIsQueryLimitReached((Boolean)isQueryLimitReached);
        }
    }

    IReportContent regenerateCache(MasterReport report, int yieldRate, String key, int acceptedPage) throws ReportProcessingException {
        logger.warn((Object)("Regenerating report data for " + key));
        IReportContent result = this.produceCacheablePages(report, yieldRate, key, acceptedPage);
        IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
        if (listener != null) {
            this.persistContent(key, result, listener.getTotalRows());
        } else {
            this.persistContent(key, result, report.getQueryLimit());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReportContent produceCacheablePages(MasterReport report, int yieldRate, String key, int acceptedPage) throws ReportProcessingException {
        IReportContent iReportContent;
        CacheListener cacheListener;
        PageableReportProcessor proc;
        block11: {
            this.processor = proc = this.createReportProcessor(report, yieldRate);
            PageableHtmlOutputProcessor outputProcessor = (PageableHtmlOutputProcessor)proc.getOutputProcessor();
            outputProcessor.setFlowSelector((FlowSelector)new DisplayAllFlowSelector());
            IAsyncReportListener listener = ReportListenerThreadHolder.getListener();
            cacheListener = null;
            try {
                Repository targetRepository = this.reinitOutputTargetRepo();
                if (listener != null) {
                    if (listener.isFirstPageMode()) {
                        cacheListener = new CacheListener(key, acceptedPage, proc, targetRepository, listener);
                        proc.addReportProgressListener((ReportProgressListener)cacheListener);
                    }
                    proc.addReportProgressListener((ReportProgressListener)listener);
                }
                proc.processReport();
                iReportContent = this.produceReportContent(proc, targetRepository);
                if (listener == null) break block11;
            }
            catch (IOException | ReportDataFactoryException | ReportParameterValidationException | ContentIOException e) {
                if (e.getMessage() != null && listener != null) {
                    listener.setErrorMessage(e.getMessage());
                }
                IReportContent iReportContent2 = null;
                return iReportContent2;
            }
            finally {
                if (listener != null) {
                    proc.removeReportProgressListener((ReportProgressListener)listener);
                }
                if (cacheListener != null) {
                    proc.removeReportProgressListener(cacheListener);
                }
            }
            proc.removeReportProgressListener((ReportProgressListener)listener);
        }
        if (cacheListener != null) {
            proc.removeReportProgressListener((ReportProgressListener)cacheListener);
        }
        return iReportContent;
    }

    int generateNonCaching(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return super.generate(report, acceptedPage, outputStream, yieldRate);
    }

    public IReportContent getCachedContent(String key) {
        IPluginCacheManager cacheManager = (IPluginCacheManager)PentahoSystem.get(IPluginCacheManager.class);
        IReportContentCache cache = cacheManager.getCache();
        return cache.get(key);
    }

    private Map<String, Serializable> getCachedMetaData(String key) {
        IPluginCacheManager cacheManager = (IPluginCacheManager)PentahoSystem.get(IPluginCacheManager.class);
        IReportContentCache cache = cacheManager.getCache();
        return cache.getMetaData(key);
    }

    private synchronized void persistContent(String key, IReportContent data, int reportTotalRows) {
        IPluginCacheManager cacheManager = (IPluginCacheManager)PentahoSystem.get(IPluginCacheManager.class);
        IReportContentCache cache = cacheManager.getCache();
        if (cache != null) {
            Map<String, Serializable> metaData = cache.getMetaData(key);
            if (metaData == null) {
                metaData = new HashMap<String, Serializable>();
            }
            metaData.put(REPORT_ROWS, Integer.valueOf(reportTotalRows));
            if (this.processor.isQueryLimitReached()) {
                this.updateQueryLimitReachedFlag(metaData);
            }
            cache.put(key, data, metaData);
        } else {
            logger.error((Object)"Plugin session cache is not available.");
        }
    }

    private Map<String, Serializable> updateQueryLimitReachedFlag(Map<String, Serializable> metaData) {
        if (metaData == null) {
            metaData = new HashMap<String, Serializable>();
        }
        metaData.put(IS_QUERY_LIMIT_REACHED, Boolean.valueOf(this.processor.isQueryLimitReached()));
        return metaData;
    }

    private Serializable computeCacheKey(MasterReport report) throws BeanException {
        ResourceKey definitionSource = report.getDefinitionSource();
        ResourceKey parent = definitionSource.getParent();
        List<String> sourceKey = parent != null ? this.computeDefSourceKey(report, parent) : this.computeDefSourceKey(report, definitionSource);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query-limit", String.valueOf(report.getQueryLimit()));
        ReportParameterDefinition parameterDefinition = report.getParameterDefinition();
        ReportParameterValues parameterValues = report.getParameterValues();
        for (ParameterDefinitionEntry p : parameterDefinition.getParameterDefinitions()) {
            String name = p.getName();
            Object o = parameterValues.get(name);
            if (o == null) {
                params.put(name, null);
                continue;
            }
            params.put(name, ConverterRegistry.toAttributeValue((Object)o));
        }
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(sourceKey);
        key.add(params);
        return key;
    }

    private List<String> computeDefSourceKey(MasterReport report, ResourceKey definitionSource) {
        String rawDataVersion;
        ArrayList<String> sourceKey = new ArrayList<String>();
        if (definitionSource.getIdentifierAsString() != null) {
            sourceKey.add(String.valueOf(definitionSource.getSchema()));
            sourceKey.add(definitionSource.getIdentifierAsString());
        }
        if (null != (rawDataVersion = this.getRawDataVersion(report, definitionSource))) {
            sourceKey.add(rawDataVersion);
        }
        return sourceKey;
    }

    private String getRawDataVersion(MasterReport report, ResourceKey definitionSource) {
        String result = null;
        ResourceManager resourceManager = report.getResourceManager();
        if (resourceManager == null) {
            resourceManager = new ResourceManager();
        }
        try {
            ResourceData resourceData = resourceManager.loadRawData(definitionSource);
            long version = resourceData.getVersion(resourceManager);
            if (version != -1L) {
                result = String.valueOf(version);
            }
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)"Can't load resource data for cache key computation: ", (Throwable)e);
        }
        return result;
    }

    private byte[] keyToBytes(Serializable s) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(s);
        oout.close();
        bout.toByteArray();
        return bout.toByteArray();
    }

    public String createKey(MasterReport report) throws CacheKeyException {
        try {
            Serializable keyRaw = this.computeCacheKey(report);
            byte[] text = this.keyToBytes(keyRaw);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text);
            byte[] digest = md.digest();
            return new String(Base64.encode((byte[])digest));
        }
        catch (Exception b) {
            throw new CacheKeyException(b);
        }
    }

    private int getReportTotalRows(String key) {
        Serializable reportTotalRows;
        Map<String, Serializable> metaData = this.getCachedMetaData(key);
        if (metaData != null && (reportTotalRows = metaData.get(REPORT_ROWS)) != null) {
            return (Integer)reportTotalRows;
        }
        return -1;
    }

    public String getJcrOutputPath() {
        return this.jcrOutputPath;
    }

    public void setJcrOutputPath(String jcrOutputPath) {
        this.jcrOutputPath = jcrOutputPath;
    }

    private static class CacheKeyException
    extends Exception {
        private CacheKeyException(Throwable cause) {
            super(cause);
        }
    }

    private class CacheListener
    implements ReportProgressListener {
        private final String key;
        private final int acceptedPage;
        private final PageableReportProcessor proc;
        private final Repository targetRepository;
        private final IAsyncReportListener asyncReportListener;
        private int lastAcceptedPageWritten;

        private CacheListener(String key, int acceptedPage, PageableReportProcessor proc, Repository targetRepository, IAsyncReportListener asyncReportListener) {
            this.key = key;
            this.acceptedPage = acceptedPage;
            this.proc = proc;
            this.targetRepository = targetRepository;
            this.asyncReportListener = asyncReportListener;
        }

        public void reportProcessingStarted(ReportProgressEvent reportProgressEvent) {
        }

        public void reportProcessingUpdate(ReportProgressEvent reportProgressEvent) {
            boolean needToStorePages;
            int page = this.asyncReportListener.getRequestedPage() > 0 ? Math.max(this.asyncReportListener.getRequestedPage() + 2, reportProgressEvent.getPage()) : this.acceptedPage + 2;
            this.asyncReportListener.setIsQueryLimitReached(this.proc.isQueryLimitReached());
            boolean bl = needToStorePages = reportProgressEvent.getPage() == page && reportProgressEvent.getPage() > this.lastAcceptedPageWritten;
            if (reportProgressEvent.getActivity() == 3 && needToStorePages) {
                try {
                    CachingPageableHTMLOutput.this.persistContent(this.key, CachingPageableHTMLOutput.this.produceReportContent(this.proc, this.targetRepository), reportProgressEvent.getMaximumRow());
                    this.lastAcceptedPageWritten = page;
                    this.asyncReportListener.updateGenerationStatus(page - 1);
                    this.asyncReportListener.setStatus(AsyncExecutionStatus.CONTENT_AVAILABLE);
                }
                catch (Exception e) {
                    logger.error((Object)"Can't persist");
                }
            }
        }

        public void reportProcessingFinished(ReportProgressEvent reportProgressEvent) {
        }
    }
}

