/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.datasources;

import java.util.Date;
import java.util.Locale;
import javax.swing.event.TableModelListener;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DefaultTableMetaData;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class QuerylessTableModel
implements CloseableTableModel,
MetaTableModel {
    private Query query;
    private DefaultTableMetaData metaData;
    private static final Date DEFAULT_DATE = new Date();
    private static final Double DEFAULT_NUMBER = new Double(123.45);
    private static final String DEFAULT_STRING_KEY_FOR_ROW = "QuerylessTableModel.DEFAULT_STRING_VALUE_ROW_";
    private static final int DEFAULT_ROW_COUNT = 2;

    public void setQuery(Query query) {
        this.query = query;
        this.metaData = new DefaultTableMetaData(query.getSelections().size());
        for (int column = 0; column < query.getSelections().size(); ++column) {
            LogicalColumn col = ((Selection)query.getSelections().get(column)).getLogicalColumn();
            Locale locale = LocaleHelper.getLocale();
            String name = col.getName(locale.toString());
            this.metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", (Object)name);
            Class<?> clazz = this.getColumnClass(column);
            if (clazz != Float.class) continue;
            this.metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "currency", (Object)false);
            this.metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "scale", (Object)0);
            this.metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "signed", (Object)false);
            this.metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "precision", (Object)Integer.MAX_VALUE);
        }
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public Class<?> getColumnClass(int index) {
        LogicalColumn column = ((Selection)this.query.getSelections().get(index)).getLogicalColumn();
        DataType dataType = column.getDataType();
        if (DataType.BOOLEAN == dataType) {
            return Boolean.class;
        }
        if (DataType.DATE == dataType) {
            return Date.class;
        }
        if (DataType.NUMERIC == dataType) {
            return Float.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return this.query.getSelections().size();
    }

    public String getColumnName(int index) {
        LogicalColumn col = ((Selection)this.query.getSelections().get(index)).getLogicalColumn();
        String name = col.getId();
        return name;
    }

    public int getRowCount() {
        return 2;
    }

    public Object getValueAt(int row, int column) {
        LogicalColumn col = ((Selection)this.query.getSelections().get(column)).getLogicalColumn();
        DataType dataType = col.getDataType();
        if (DataType.BOOLEAN == dataType) {
            return row % 2;
        }
        if (DataType.DATE == dataType) {
            Date d = new Date(DEFAULT_DATE.getTime());
            d.setDate(row);
            return d;
        }
        if (DataType.NUMERIC == dataType) {
            return DEFAULT_NUMBER + (double)row;
        }
        return Messages.getInstance().getString(DEFAULT_STRING_KEY_FOR_ROW + String.valueOf(row), new Object[]{String.valueOf(column)});
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void close() {
    }

    public DataAttributes getColumnAttributes(int column) {
        if (this.metaData == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaData.getColumnAttribute(column);
    }

    public DataAttributes getCellDataAttributes(int row, int column) {
        return null;
    }

    public DataAttributes getTableAttributes() {
        return this.metaData.getTableAttribute();
    }

    public boolean isCellDataAttributesSupported() {
        return false;
    }
}

