/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.platform.plugin.cache.AbstractReportContentCache;
import org.pentaho.reporting.platform.plugin.cache.ICacheBackend;

public class PluginSessionCache
extends AbstractReportContentCache {
    private static final Log logger = LogFactory.getLog(PluginSessionCache.class);
    private static final String SEGMENT = "session";

    public PluginSessionCache(ICacheBackend backend) {
        super(backend);
        PentahoSystem.addLogoutListener((ILogoutListener)new LogoutHandler());
    }

    public PluginSessionCache() {
        PentahoSystem.addLogoutListener((ILogoutListener)new LogoutHandler());
    }

    @Override
    protected List<String> computeKey(String key) {
        IPentahoSession session = PentahoSessionHolder.getSession();
        return Collections.unmodifiableList(Arrays.asList(SEGMENT, session.getId(), key));
    }

    @Override
    public void cleanup() {
        this.getBackend().purge(Collections.singletonList(SEGMENT));
    }

    @Override
    public void cleanupCurrentSession() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        this.getBackend().purge(Collections.unmodifiableList(Arrays.asList(SEGMENT, session.getId())));
    }

    private class LogoutHandler
    implements ILogoutListener {
        private LogoutHandler() {
        }

        public void onLogout(IPentahoSession session) {
            logger.debug((Object)("Shutting down session " + session.getId()));
            ICacheBackend backend = PluginSessionCache.this.getBackend();
            backend.purge(Collections.unmodifiableList(Arrays.asList(PluginSessionCache.SEGMENT, session.getId())));
            logger.debug((Object)("Purged session cache " + session.getId()));
        }
    }
}

