/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.libraries.xmlns.parser.Base64;
import org.pentaho.reporting.platform.plugin.cache.AbstractReportContentCache;
import org.pentaho.reporting.platform.plugin.cache.BiPredicate;
import org.pentaho.reporting.platform.plugin.cache.ICacheBackend;
import org.pentaho.reporting.platform.plugin.cache.IReportContent;

public class DeleteOldOnAccessCache
extends AbstractReportContentCache {
    private static final Log logger = LogFactory.getLog(DeleteOldOnAccessCache.class);
    private static final String SEGMENT = "long_term";
    public static final String TIMESTAMP = "timestamp";
    public static final int MILLIS_IN_DAY = 86400000;
    public static final String ANONYMOUS = "anonymous";
    private long millisToLive;

    public DeleteOldOnAccessCache(ICacheBackend backend) {
        super(backend);
    }

    public DeleteOldOnAccessCache() {
    }

    public void setDaysToLive(long daysToLive) {
        this.millisToLive = 86400000L * daysToLive;
    }

    protected void setMillisToLive(long millisToLive) {
        this.millisToLive = millisToLive;
    }

    @Override
    protected List<String> computeKey(String key) {
        IPentahoSession session = PentahoSessionHolder.getSession();
        return Collections.unmodifiableList(Arrays.asList(SEGMENT, this.createKey(session.getName()), key));
    }

    @Override
    public boolean put(String key, IReportContent value) {
        return this.put(key, value, new HashMap<String, Serializable>());
    }

    @Override
    public boolean put(String key, IReportContent value, Map<String, Serializable> metaData) {
        this.cleanUp();
        metaData.put(TIMESTAMP, Long.valueOf(System.currentTimeMillis()));
        this.getBackend().write(this.computeKey(key), value, metaData);
        return false;
    }

    @Override
    public IReportContent get(String key) {
        this.cleanUp();
        return super.get(key);
    }

    @Override
    public Map<String, Serializable> getMetaData(String key) {
        this.cleanUp();
        return super.getMetaData(key);
    }

    @Override
    public void cleanup() {
        this.cleanUp();
    }

    @Override
    public void cleanupCurrentSession() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        List<String> key = Collections.unmodifiableList(Arrays.asList(SEGMENT, this.createKey(session.getName())));
        ICacheBackend backend = this.getBackend();
        backend.purgeSegment(key, (k, m) -> true);
    }

    private void cleanUp() {
        logger.debug((Object)"Starting periodical cache eviction");
        final long currentTimeMillis = System.currentTimeMillis();
        ICacheBackend backend = this.getBackend();
        backend.purgeSegment(Collections.singletonList(SEGMENT), new BiPredicate<List<String>, Map<String, Serializable>>(){

            @Override
            public boolean test(List<String> key, Map<String, Serializable> md) {
                long timestamp;
                Serializable o = md.get(DeleteOldOnAccessCache.TIMESTAMP);
                if (o instanceof Long && currentTimeMillis - (timestamp = ((Long)o).longValue()) > DeleteOldOnAccessCache.this.millisToLive) {
                    logger.debug((Object)("Purged long-term cache: " + key));
                    return true;
                }
                return false;
            }
        });
        logger.debug((Object)"Finished periodical cache eviction");
    }

    private String createKey(String key) {
        if (StringUtil.isEmpty((String)key)) {
            return ANONYMOUS;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(key.getBytes());
            byte[] digest = md.digest();
            return new String(Base64.encode((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

