/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.platform.plugin.cache.ICacheBackend;
import org.pentaho.reporting.platform.plugin.cache.IReportContent;
import org.pentaho.reporting.platform.plugin.cache.IReportContentCache;

public abstract class AbstractReportContentCache
implements IReportContentCache {
    private ICacheBackend backend;

    public AbstractReportContentCache() {
    }

    public AbstractReportContentCache(ICacheBackend backend) {
        this.backend = backend;
    }

    @Override
    public boolean put(String key, IReportContent value) {
        return this.put(key, value, new HashMap<String, Serializable>());
    }

    @Override
    public boolean put(String key, IReportContent value, Map<String, Serializable> metaData) {
        return this.getBackend().write(this.computeKey(key), value, metaData);
    }

    @Override
    public IReportContent get(String key) {
        return (IReportContent)this.getBackend().read(this.computeKey(key));
    }

    @Override
    public Map<String, Serializable> getMetaData(String key) {
        return this.getBackend().readMetaData(this.computeKey(key));
    }

    public ICacheBackend getBackend() {
        return this.backend;
    }

    public void setBackend(ICacheBackend backend) {
        this.backend = backend;
    }

    protected abstract List<String> computeKey(String var1);
}

