/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.platform.plugin.async.HomeSchedulingDirStrategy;

public class ProvidedSchedulingDirStrategy
extends HomeSchedulingDirStrategy {
    private static final String PREFIX = "/";
    private final String providedDir;

    public ProvidedSchedulingDirStrategy(String providedDir) {
        this.providedDir = providedDir;
    }

    @Override
    public RepositoryFile getSchedulingDir(IUnifiedRepository repo) {
        if (StringUtil.isEmpty((String)this.providedDir)) {
            return super.getSchedulingDir(repo);
        }
        if (this.providedDir.startsWith(PREFIX)) {
            RepositoryFile file = repo.getFile(this.providedDir);
            if (file != null && file.isFolder()) {
                return file;
            }
        } else {
            RepositoryFile file;
            RepositoryFile parentDir = super.getSchedulingDir(repo);
            if (parentDir != null && (file = repo.getFile(parentDir.getPath() + PREFIX + this.providedDir)) != null && file.isFolder()) {
                return file;
            }
        }
        return super.getSchedulingDir(repo);
    }
}

