/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.platform.plugin.async.IJobIdGenerator;

public class JobIdGenerator
implements ILogoutListener,
IJobIdGenerator {
    private static final String SESSION = "session";
    public static final String ID = "id";
    private ConcurrentHashMap<IPentahoSession, Set<Object>> reservedIds = new ConcurrentHashMap();

    public JobIdGenerator() {
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    public void onLogout(IPentahoSession session) {
        if (session != null) {
            this.reservedIds.remove(session);
        }
    }

    @Override
    public UUID generateId(IPentahoSession session) {
        ArgumentNullException.validate((String)SESSION, (Object)session);
        Set freshSet = Sets.newConcurrentHashSet();
        UUID uuid = UUID.randomUUID();
        Set sessionIds = this.reservedIds.putIfAbsent(session, freshSet);
        if (sessionIds == null) {
            sessionIds = freshSet;
        }
        sessionIds.add(uuid);
        return uuid;
    }

    @Override
    public boolean acquire(IPentahoSession session, UUID id) {
        ArgumentNullException.validate((String)SESSION, (Object)session);
        return this.reservedIds.getOrDefault(session, Collections.emptySet()).remove(id);
    }
}

