/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import java.util.UUID;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.platform.plugin.async.IPentahoAsyncExecutor;

class AutoScheduleListener
implements ReportProgressListener {
    private boolean scheduled = false;
    private int threshold;
    private UUID id;
    private IPentahoSession session;
    private IPentahoAsyncExecutor pentahoAsyncExecutor;

    protected AutoScheduleListener(UUID id, IPentahoSession session, int threshold, IPentahoAsyncExecutor pentahoAsyncExecutor) {
        this.id = id;
        this.threshold = threshold;
        this.session = session;
        this.pentahoAsyncExecutor = pentahoAsyncExecutor;
    }

    private synchronized void autoSchedule(ReportProgressEvent reportProgressEvent) {
        if (!this.scheduled && this.threshold > 0 && reportProgressEvent != null && reportProgressEvent.getMaximumRow() > this.threshold) {
            this.pentahoAsyncExecutor.preSchedule(this.id, this.session);
            this.scheduled = true;
        }
    }

    public void reportProcessingStarted(ReportProgressEvent reportProgressEvent) {
        this.autoSchedule(reportProgressEvent);
    }

    public void reportProcessingUpdate(ReportProgressEvent reportProgressEvent) {
        this.autoSchedule(reportProgressEvent);
    }

    public void reportProcessingFinished(ReportProgressEvent reportProgressEvent) {
    }
}

