/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessorThreadHolder;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.AsyncReportState;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;

public class AsyncReportStatusListener
implements IAsyncReportListener {
    private static final String COMPUTING_LAYOUT = "AsyncComputingLayoutTitle";
    private static final String PRECOMPUTING_VALUES = "AsyncPrecomputingValuesTitle";
    private static final String PAGINATING = "AsyncPaginatingTitle";
    private static final String GENERATING_CONTENT = "AsyncGeneratingContentTitle";
    private final String path;
    private final UUID uuid;
    private final String mimeType;
    private final List<? extends ReportProgressListener> callbackListeners;
    private String errorMessage = null;
    private AsyncExecutionStatus status = AsyncExecutionStatus.QUEUED;
    private int progress = 0;
    private int page = 0;
    private int row = 0;
    private int totalPages = 0;
    private int totalRows = 0;
    private String activity;
    private boolean firstPageMode = false;
    private int requestedPage = 0;
    private int generatedPage = 0;
    private boolean isQueryLimitReached;
    private boolean manuallyInterrupted;

    public AsyncReportStatusListener(String path, UUID uuid, String mimeType, List<? extends ReportProgressListener> callbackListeners) {
        ArgumentNullException.validate((String)"callbackListeners", callbackListeners);
        this.path = path;
        this.uuid = uuid;
        this.mimeType = mimeType;
        this.callbackListeners = Collections.unmodifiableList(callbackListeners);
        ExtendedConfiguration config = ClassicEngineBoot.getInstance().getExtendedConfig();
        this.firstPageMode = config.getBoolProperty("org.pentaho.reporting.platform.plugin.output.FirstPageMode");
    }

    @Override
    public synchronized void setStatus(AsyncExecutionStatus status) {
        if (this.status == null || !this.status.isFinal()) {
            this.status = status;
        }
    }

    @Override
    public synchronized void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public boolean isFirstPageMode() {
        return this.firstPageMode;
    }

    public synchronized void setRequestedPage(int requestedPage) {
        this.requestedPage = requestedPage;
    }

    @Override
    public synchronized int getRequestedPage() {
        return this.requestedPage;
    }

    @Override
    public synchronized void updateGenerationStatus(int generatedPage) {
        this.generatedPage = generatedPage;
        this.requestedPage = 0;
    }

    @Override
    public synchronized boolean isScheduled() {
        return AsyncExecutionStatus.SCHEDULED.equals((Object)this.status);
    }

    public synchronized void reportProcessingStarted(ReportProgressEvent event) {
        this.setStatus(AsyncExecutionStatus.WORKING);
        if (CollectionUtils.isNotEmpty(this.callbackListeners)) {
            for (ReportProgressListener reportProgressListener : this.callbackListeners) {
                reportProgressListener.reportProcessingStarted(event);
            }
        }
    }

    public synchronized void reportProcessingUpdate(ReportProgressEvent event) {
        AbstractReportProcessor processor;
        if (this.manuallyInterrupted && (processor = ReportProcessorThreadHolder.getProcessor()) != null) {
            processor.cancel();
        }
        this.updateState(event);
        if (CollectionUtils.isNotEmpty(this.callbackListeners)) {
            for (ReportProgressListener reportProgressListener : this.callbackListeners) {
                reportProgressListener.reportProcessingUpdate(event);
            }
        }
    }

    public synchronized void reportProcessingFinished(ReportProgressEvent event) {
        if (CollectionUtils.isNotEmpty(this.callbackListeners)) {
            for (ReportProgressListener reportProgressListener : this.callbackListeners) {
                reportProgressListener.reportProcessingFinished(event);
            }
        }
    }

    public String toString() {
        return "AsyncReportStatusListener{path='" + this.path + '\'' + ", uuid=" + this.uuid + ", status=" + (Object)((Object)this.status) + ", progress=" + this.progress + ", page=" + this.page + ", totalPages=" + this.totalPages + ", generatedPage=" + this.generatedPage + ", activity='" + this.activity + '\'' + ", row=" + this.row + ", firstPageMode=" + this.firstPageMode + ", mimeType='" + this.mimeType + '\'' + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    private void updateState(ReportProgressEvent event) {
        this.activity = AsyncReportStatusListener.getActivityCode(event.getActivity());
        this.progress = (int)ReportProgressEvent.computePercentageComplete((ReportProgressEvent)event, (boolean)true);
        this.page = event.getPage();
        this.row = event.getRow();
        this.totalRows = event.getMaximumRow();
        this.totalPages = event.getTotalPages();
    }

    private static String getActivityCode(int activity) {
        String result = "";
        switch (activity) {
            case 0: {
                result = COMPUTING_LAYOUT;
                break;
            }
            case 1: {
                result = PRECOMPUTING_VALUES;
                break;
            }
            case 2: {
                result = PAGINATING;
                break;
            }
            case 3: {
                result = GENERATING_CONTENT;
            }
        }
        return result;
    }

    public synchronized IAsyncReportState getState() {
        return new AsyncReportState(this.uuid, this.path, this.status, this.progress, this.row, this.totalRows, this.page, this.totalPages, this.generatedPage, this.activity, this.mimeType, this.errorMessage, this.isQueryLimitReached);
    }

    @Override
    public boolean isQueryLimitReached() {
        return this.isQueryLimitReached;
    }

    @Override
    public void setIsQueryLimitReached(boolean isQueryLimitReached) {
        this.isQueryLimitReached = isQueryLimitReached;
    }

    @Override
    public int getTotalRows() {
        return this.totalRows;
    }

    public synchronized void cancel() {
        this.manuallyInterrupted = true;
        this.setStatus(AsyncExecutionStatus.CANCELED);
    }
}

