/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IStreamProcessingAction;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.modules.java14print.Java14PrintUtil;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.platform.plugin.PentahoPlatformModule;
import org.pentaho.reporting.platform.plugin.PentahoReportEnvironment;
import org.pentaho.reporting.platform.plugin.ReportContentUtil;
import org.pentaho.reporting.platform.plugin.ReportCreator;
import org.pentaho.reporting.platform.plugin.ReportingSystemStartupListener;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.cache.DefaultReportCache;
import org.pentaho.reporting.platform.plugin.cache.NullReportCache;
import org.pentaho.reporting.platform.plugin.cache.ReportCache;
import org.pentaho.reporting.platform.plugin.cache.ReportCacheKey;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.FastExportReportOutputHandlerFactory;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerFactory;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerSelector;

public class SimpleReportingAction
implements IStreamProcessingAction,
IStreamingAction,
IVarArgsAction {
    private static final Log log = LogFactory.getLog(SimpleReportingAction.class);
    public static final String OUTPUT_TARGET = "output-target";
    public static final String OUTPUT_TYPE = "output-type";
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_EMAIL = "mime-message/text/html";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_XLS = "application/vnd.ms-excel";
    public static final String MIME_TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String MIME_TYPE_RTF = "application/rtf";
    public static final String MIME_TYPE_CSV = "text/csv";
    public static final String MIME_TYPE_TXT = "text/plain";
    public static final String MIME_TYPE_XML = "application/xml";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String XLS_WORKBOOK_PARAM = "workbook";
    public static final String REPORTLOAD_RESURL = "res-url";
    public static final String REPORT_DEFINITION_INPUT = "report-definition";
    public static final String USE_JCR = "useJcr";
    public static final String REPORTHTML_CONTENTHANDLER_PATTERN = "content-handler-pattern";
    public static final String REPORTGENERATE_YIELDRATE = "yield-rate";
    public static final String ACCEPTED_PAGE = "accepted-page";
    public static final String PAGINATE_OUTPUT = "paginate";
    public static final String PRINT = "print";
    public static final String PRINTER_NAME = "printer-name";
    public static final String DASHBOARD_MODE = "dashboard-mode";
    public static final String MIME_GENERIC_FALLBACK = "application/octet-stream";
    public static final String PNG_EXPORT_TYPE = "pageable/X-AWT-Graphics;image-type=png";
    private String outputType;
    private String outputTarget;
    private String defaultOutputTarget = "table/html;page-mode=stream";
    private MasterReport report;
    private Map<String, Object> inputs = Collections.emptyMap();
    private OutputStream outputStream;
    private InputStream reportDefinitionInputStream;
    private IActionSequenceResource reportDefinition;
    private String reportDefinitionPath;
    private boolean paginateOutput = false;
    private int acceptedPage = -1;
    private int pageCount = -1;
    private boolean dashboardMode;
    private Boolean useJcr = Boolean.FALSE;
    private String jcrOutputPath;
    private boolean print = false;
    private String printer;

    public String getDefaultOutputTarget() {
        return this.defaultOutputTarget;
    }

    public void setDefaultOutputTarget(String defaultOutputTarget) {
        if (defaultOutputTarget == null) {
            throw new NullPointerException();
        }
        this.defaultOutputTarget = defaultOutputTarget;
    }

    public String getOutputTarget() {
        return this.outputTarget;
    }

    public void setOutputTarget(String outputTarget) {
        this.outputTarget = outputTarget;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public IActionSequenceResource getReportDefinition() {
        return this.reportDefinition;
    }

    public void setReportDefinition(IActionSequenceResource reportDefinition) {
        this.reportDefinition = reportDefinition;
    }

    public void setInputStream(InputStream reportDefinitionInputStream) {
        this.reportDefinitionInputStream = reportDefinitionInputStream;
    }

    public String getReportDefinitionPath() {
        return this.reportDefinitionPath;
    }

    public void setReportDefinitionPath(String reportDefinitionPath) {
        this.reportDefinitionPath = reportDefinitionPath;
    }

    public boolean isPaginateOutput() {
        return this.paginateOutput;
    }

    public void setPaginateOutput(boolean paginateOutput) {
        this.paginateOutput = paginateOutput;
    }

    public int getAcceptedPage() {
        return this.acceptedPage;
    }

    public void setAcceptedPage(int acceptedPage) {
        this.acceptedPage = acceptedPage;
    }

    public boolean isDashboardMode() {
        return this.dashboardMode;
    }

    public void setDashboardMode(boolean dashboardMode) {
        this.dashboardMode = dashboardMode;
    }

    public boolean getUseJCR() {
        return this.useJcr;
    }

    public void setUseJcr(Boolean useJcr) {
        this.useJcr = useJcr;
    }

    public String getJcrOutputPath() {
        return this.jcrOutputPath;
    }

    public void setJcrOutputPath(String jcrOutputPath) {
        this.jcrOutputPath = jcrOutputPath;
    }

    public String getMimeType(String ignored) {
        return this.getMimeType();
    }

    public String getMimeType() {
        try {
            ReportOutputHandlerFactory handlerFactory;
            String outputTarget = this.computeEffectiveOutputTarget();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getInstance().getString("ReportPlugin.logComputedOutputTarget", new Object[]{outputTarget}));
            }
            if ((handlerFactory = (ReportOutputHandlerFactory)PentahoSystem.get(ReportOutputHandlerFactory.class)) == null) {
                handlerFactory = new FastExportReportOutputHandlerFactory();
            }
            return handlerFactory.getMimeType(new InternalOutputHandlerSelector(outputTarget));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorMimeTypeFull"), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorMimeTypeShort", new Object[]{e.getMessage()}));
            }
            return MIME_GENERIC_FALLBACK;
        }
        catch (ResourceException e) {
            if (log.isDebugEnabled()) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorMimeTypeFull"), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorMimeTypeShort", new Object[]{e.getMessage()}));
            }
            return MIME_GENERIC_FALLBACK;
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public Map<String, Object> getInputs() {
        if (this.inputs != null) {
            return Collections.unmodifiableMap(this.inputs);
        }
        return Collections.emptyMap();
    }

    public void setVarArgs(Map<String, Object> inputs) {
        if (inputs == null) {
            this.inputs = Collections.emptyMap();
            return;
        }
        this.inputs = inputs;
    }

    protected Object getInput(String key, Object defaultValue) {
        Object input;
        if (this.inputs != null && (input = this.inputs.get(key)) != null) {
            return input;
        }
        return defaultValue;
    }

    public void setReport(MasterReport report) {
        this.report = report;
        String clText = this.extractContentLinkSpec();
        report.setReportEnvironment((ReportEnvironment)new PentahoReportEnvironment(report.getConfiguration(), clText, SimpleReportingComponent.getReportPath(report.getContentBase())));
    }

    public MasterReport getReport() throws ResourceException, IOException {
        if (this.report == null) {
            if (this.reportDefinitionInputStream != null) {
                Serializable fileId;
                RepositoryFileInputStream repositoryFileInputStream;
                RepositoryFile repoFile;
                if (this.reportDefinitionInputStream instanceof RepositoryFileInputStream && (repoFile = (repositoryFileInputStream = (RepositoryFileInputStream)this.reportDefinitionInputStream).getFile()) != null && (fileId = repoFile.getId()) != null) {
                    this.report = ReportCreator.createReport(fileId);
                }
                if (this.report == null) {
                    this.report = ReportCreator.createReport(this.reportDefinitionInputStream, this.getDefinedResourceURL(null));
                }
            } else if (this.reportDefinition != null) {
                this.report = ReportCreator.createReport((Serializable)((Object)this.reportDefinition.getAddress()));
            } else if (this.reportDefinitionPath != null) {
                this.report = ReportCreator.createReportByName(this.reportDefinitionPath);
            } else {
                throw new ResourceException();
            }
            String clText = this.extractContentLinkSpec();
            this.report.setReportEnvironment((ReportEnvironment)new PentahoReportEnvironment(this.report.getConfiguration(), clText, SimpleReportingComponent.getReportPath(this.report.getContentBase())));
        }
        try {
            IPluginManager pm = (IPluginManager)PentahoSystem.get(IPluginManager.class);
            if (pm != null) {
                Object autoSubmitDefaultSetting;
                Object autoSubmitSetting = pm.getPluginSetting("reporting", "settings/auto-submit", null);
                if (autoSubmitSetting != null) {
                    boolean autoSubmit = Boolean.parseBoolean(autoSubmitSetting.toString());
                    this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-parameter", (Object)autoSubmit);
                }
                if ((autoSubmitDefaultSetting = pm.getPluginSetting("reporting", "settings/auto-submit-default", null)) != null) {
                    boolean autoSubmitDefault = Boolean.parseBoolean(autoSubmitDefaultSetting.toString());
                    this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-default", (Object)autoSubmitDefault);
                }
            }
        }
        catch (Throwable t) {
            log.warn((Object)t.getMessage(), t);
        }
        this.report.setQueryLimit(-1);
        return this.report;
    }

    private String extractContentLinkSpec() {
        if (this.inputs == null) {
            return null;
        }
        Object clRaw = this.inputs.get("::cl");
        if (clRaw == null) {
            return null;
        }
        if (clRaw instanceof Collection) {
            Collection c = (Collection)clRaw;
            CSVQuoter quoter = new CSVQuoter(',', '\"');
            StringBuilder b = new StringBuilder();
            for (Object o : c) {
                String s = quoter.doQuoting(String.valueOf(o));
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(s);
            }
            return b.toString();
        }
        if (clRaw.getClass().isArray()) {
            CSVQuoter quoter = new CSVQuoter(',', '\"');
            StringBuilder b = new StringBuilder();
            int size = Array.getLength(clRaw);
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(clRaw, i);
                String s = quoter.doQuoting(String.valueOf(o));
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(s);
            }
            return b.toString();
        }
        return String.valueOf(clRaw);
    }

    private boolean isValidOutputType(String outputType) {
        if (PNG_EXPORT_TYPE.equals(outputType)) {
            return true;
        }
        return ReportProcessTaskRegistry.getInstance().isExportTypeRegistered(outputType);
    }

    private String computeEffectiveOutputTarget() throws IOException, ResourceException {
        String outputTarget;
        Object preferredOutputType;
        MasterReport report = this.getReport();
        if (Boolean.TRUE.equals(report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "lock-preferred-output-type")) && (preferredOutputType = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "preferred-output-type")) != null) {
            String preferredOutputTypeString = String.valueOf(preferredOutputType);
            if (this.isValidOutputType(preferredOutputTypeString)) {
                return preferredOutputTypeString;
            }
            String mappedLegacyType = this.mapOutputTypeToOutputTarget(preferredOutputTypeString);
            if (mappedLegacyType != null) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnLegacyLockedOutput", new Object[]{preferredOutputTypeString}));
                return mappedLegacyType;
            }
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnInvalidLockedOutput", new Object[]{preferredOutputTypeString}));
        }
        if ((outputTarget = this.getOutputTarget()) != null) {
            if (!this.isValidOutputType(outputTarget)) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnInvalidOutputTarget", new Object[]{outputTarget}));
            }
            return outputTarget;
        }
        String mappingFromParams = this.mapOutputTypeToOutputTarget(this.getOutputType());
        if (mappingFromParams != null) {
            return mappingFromParams;
        }
        Object preferredOutputType2 = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "preferred-output-type");
        if (preferredOutputType2 != null) {
            String preferredOutputTypeString = String.valueOf(preferredOutputType2);
            if (this.isValidOutputType(preferredOutputTypeString)) {
                return preferredOutputTypeString;
            }
            String mappedLegacyType = this.mapOutputTypeToOutputTarget(preferredOutputTypeString);
            if (mappedLegacyType != null) {
                log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnLegacyPreferredOutput", new Object[]{preferredOutputTypeString}));
                return mappedLegacyType;
            }
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnInvalidPreferredOutput", new Object[]{preferredOutputTypeString, this.getDefaultOutputTarget()}));
            return this.getDefaultOutputTarget();
        }
        if (!StringUtils.isEmpty((String)this.getOutputTarget()) || !StringUtils.isEmpty((String)this.getOutputType())) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.warnInvalidOutputType", new Object[]{this.getOutputType(), this.getDefaultOutputTarget()}));
        }
        return this.getDefaultOutputTarget();
    }

    public String getComputedOutputTarget() throws IOException, ResourceException {
        return this.computeEffectiveOutputTarget();
    }

    private String mapOutputTypeToOutputTarget(String outputType) {
        if (MIME_TYPE_CSV.equals(outputType)) {
            return "table/csv;page-mode=stream";
        }
        if (MIME_TYPE_HTML.equals(outputType)) {
            if (this.isPaginateOutput()) {
                return "table/html;page-mode=page";
            }
            return "table/html;page-mode=stream";
        }
        if (MIME_TYPE_XML.equals(outputType)) {
            if (this.isPaginateOutput()) {
                return "table/xml";
            }
            return "pageable/xml";
        }
        if (MIME_TYPE_PDF.equals(outputType)) {
            return "pageable/pdf";
        }
        if (MIME_TYPE_RTF.equals(outputType)) {
            return "table/rtf;page-mode=flow";
        }
        if (MIME_TYPE_XLS.equals(outputType)) {
            return "table/excel;page-mode=flow";
        }
        if (MIME_TYPE_XLSX.equals(outputType)) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow";
        }
        if (MIME_TYPE_EMAIL.equals(outputType)) {
            return MIME_TYPE_EMAIL;
        }
        if (MIME_TYPE_TXT.equals(outputType)) {
            return "pageable/text";
        }
        if ("pdf".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedPDF"));
            return "pageable/pdf";
        }
        if ("html".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedHTML"));
            if (this.isPaginateOutput()) {
                return "table/html;page-mode=page";
            }
            return "table/html;page-mode=stream";
        }
        if ("csv".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedCSV"));
            return "table/csv;page-mode=stream";
        }
        if ("rtf".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedRTF"));
            return "table/rtf;page-mode=flow";
        }
        if ("xls".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedXLS"));
            return "table/excel;page-mode=flow";
        }
        if ("txt".equalsIgnoreCase(outputType)) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnDeprecatedTXT"));
            return "pageable/text";
        }
        return null;
    }

    public void applyInputsToReportParameters(MasterReport report, ParameterContext context) {
        try {
            if (this.getReport() != report) {
                throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorForeignReportInput"));
            }
            ValidationResult validationResult = this.applyInputsToReportParameters(context, null);
            if (!validationResult.isEmpty()) {
                throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorApplyInputsFailed"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorApplyInputsFailed"), e);
        }
        catch (ResourceException e) {
            throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorApplyInputsFailed"), e);
        }
    }

    public ValidationResult applyInputsToReportParameters(ParameterContext context, ValidationResult validationResult) throws IOException, ResourceException {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        if (this.inputs != null) {
            MasterReport report = this.getReport();
            ParameterDefinitionEntry[] params = report.getParameterDefinition().getParameterDefinitions();
            ReportParameterValues parameterValues = report.getParameterValues();
            for (ParameterDefinitionEntry param : params) {
                String paramName = param.getName();
                try {
                    Object computedParameter = ReportContentUtil.computeParameterValue(context, param, this.inputs.get(paramName));
                    parameterValues.put(param.getName(), computedParameter);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)Messages.getInstance().getString("ReportPlugin.infoParameterValues", new Object[]{paramName, String.valueOf(this.inputs.get(paramName)), String.valueOf(computedParameter)}));
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorParametrization"), (Throwable)e);
                    }
                    validationResult.addError(paramName, new ValidationMessage(e.getMessage()));
                }
            }
        }
        return validationResult;
    }

    private URL getDefinedResourceURL(URL defaultValue) {
        if (this.inputs == null || !this.inputs.containsKey(REPORTLOAD_RESURL)) {
            return defaultValue;
        }
        try {
            String inputStringValue = (String)this.getInput(REPORTLOAD_RESURL, null);
            return new URL(inputStringValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected int getYieldRate() {
        Object yieldRate = this.getInput(REPORTGENERATE_YIELDRATE, null);
        if (yieldRate instanceof Number) {
            Number n = (Number)yieldRate;
            if (n.intValue() < 1) {
                return 0;
            }
            return n.intValue();
        }
        return 0;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public boolean validate() throws Exception {
        if (this.reportDefinition == null && this.reportDefinitionInputStream == null && this.reportDefinitionPath == null) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.reportDefinitionNotProvided"));
            return false;
        }
        if (this.outputStream == null && !this.print) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.outputStreamRequired"));
            return false;
        }
        if (this.inputs == null) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.inputParameterRequired"));
            return false;
        }
        return true;
    }

    public void execute() throws Exception {
        if (!this._execute()) {
            throw new Exception("execution failed for an unspecified reason");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _execute() throws Exception {
        if (this.inputs != null && !StringUtils.isEmpty((String)this.outputTarget) && this.outputTarget.equals("table/html;page-mode=page")) {
            this.setPaginateOutput(true);
            this.inputs.put(OUTPUT_TARGET, this.getOutputTarget());
            Configuration configuration = this.report.getConfiguration();
            if (configuration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modifiableConfiguration = (ModifiableConfiguration)configuration;
                modifiableConfiguration.setConfigProperty(PentahoPlatformModule.FORCE_ALL_PAGES, "true");
            }
        }
        MasterReport report = this.getReport();
        int yieldRate = this.getYieldRate();
        if (yieldRate > 0) {
            report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.YieldRate", String.valueOf(yieldRate));
        }
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        ValidationResult vr = this.applyInputsToReportParameters((ParameterContext)parameterContext, null);
        if (!vr.isEmpty()) {
            return false;
        }
        parameterContext.close();
        if (this.isPrint()) {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (!StringUtils.isEmpty((String)this.getPrinter())) {
                PrintService[] services;
                for (PrintService service : services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
                    if (!service.getName().equals(this.printer)) continue;
                    printService = service;
                }
                if (this.printer == null && services.length > 0) {
                    printService = services[0];
                }
            }
            Java14PrintUtil.printDirectly((MasterReport)report, (PrintService)printService);
            return true;
        }
        String outputType = this.computeEffectiveOutputTarget();
        ReportOutputHandler reportOutputHandler = this.createOutputHandlerForOutputType(outputType);
        if (reportOutputHandler == null) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnUnprocessableRequest", new Object[]{outputType}));
            return false;
        }
        Object object = reportOutputHandler.getReportLock();
        synchronized (object) {
            boolean bl;
            try {
                this.pageCount = reportOutputHandler.generate(report, this.acceptedPage, this.outputStream, this.getYieldRate());
                bl = this.pageCount != -1;
                reportOutputHandler.close();
            }
            catch (Throwable throwable) {
                try {
                    reportOutputHandler.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    log.error((Object)Messages.getInstance().getString("ReportPlugin.executionFailed"), t);
                    return false;
                }
            }
            return bl;
        }
    }

    protected ReportOutputHandler createOutputHandlerForOutputType(String outputType) throws IOException {
        ReportOutputHandler reportOutputHandler;
        ReportOutputHandlerFactory handlerFactory;
        ReportCache cache;
        if (this.inputs == null) {
            throw new IllegalStateException("Inputs are null, this component did not validate properly");
        }
        Object attribute = this.report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "report-cache");
        ReportCacheKey reportCacheKey = new ReportCacheKey(this.getViewerSessionId(), this.inputs);
        if (Boolean.FALSE.equals(attribute)) {
            cache = new NullReportCache();
        } else {
            ReportOutputHandler outputHandler;
            cache = (ReportCache)PentahoSystem.get(ReportCache.class);
            if (cache == null) {
                cache = new DefaultReportCache();
            }
            if ((outputHandler = cache.get(reportCacheKey)) != null) {
                return outputHandler;
            }
        }
        if (this.dashboardMode) {
            this.report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.BodyFragment", "true");
        }
        if ((handlerFactory = (ReportOutputHandlerFactory)PentahoSystem.get(ReportOutputHandlerFactory.class)) == null) {
            handlerFactory = new FastExportReportOutputHandlerFactory();
        }
        if ((reportOutputHandler = handlerFactory.createOutputHandlerForOutputType(new InternalOutputHandlerSelector(outputType))) == null) {
            return null;
        }
        return cache.put(reportCacheKey, reportOutputHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int paginate() throws IOException, ResourceException {
        MasterReport report = this.getReport();
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        ValidationResult vr = this.applyInputsToReportParameters((ParameterContext)parameterContext, null);
        if (!vr.isEmpty()) {
            return 0;
        }
        parameterContext.close();
        if (this.isPrint()) {
            return 0;
        }
        String outputType = this.computeEffectiveOutputTarget();
        ReportOutputHandler reportOutputHandler = this.createOutputHandlerForOutputType(outputType);
        if (reportOutputHandler == null) {
            log.warn((Object)Messages.getInstance().getString("ReportPlugin.warnUnprocessableRequest", new Object[]{outputType}));
            return 0;
        }
        Object object = reportOutputHandler.getReportLock();
        synchronized (object) {
            int n;
            try {
                n = reportOutputHandler.paginate(report, this.getYieldRate());
                reportOutputHandler.close();
            }
            catch (Throwable throwable) {
                try {
                    reportOutputHandler.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    log.error((Object)Messages.getInstance().getString("ReportPlugin.executionFailed"), t);
                    return 0;
                }
            }
            return n;
        }
    }

    protected String getViewerSessionId() {
        if (this.inputs == null) {
            return null;
        }
        Object o = this.inputs.get("::session");
        if (o instanceof String) {
            return String.valueOf(o);
        }
        return null;
    }

    static {
        ReportingSystemStartupListener startup = new ReportingSystemStartupListener();
        startup.startup(null);
    }

    private class InternalOutputHandlerSelector
    implements ReportOutputHandlerSelector {
        private String outputType;

        private InternalOutputHandlerSelector(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public String getOutputType() {
            return this.outputType;
        }

        @Override
        public MasterReport getReport() {
            return SimpleReportingAction.this.report;
        }

        @Override
        public boolean isUseJcrOutput() {
            return Boolean.TRUE.equals(SimpleReportingAction.this.getUseJCR());
        }

        @Override
        public String getJcrOutputPath() {
            return SimpleReportingAction.this.getJcrOutputPath();
        }

        @Override
        public <T> T getInput(String parameterName, T defaultValue, Class<T> idx) {
            Object input = SimpleReportingAction.this.getInput(parameterName, defaultValue);
            if (input == null) {
                input = defaultValue;
            }
            return idx.cast(input);
        }
    }
}

