/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IAcceptsRuntimeInputs;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class SimpleEmailComponent
implements IAcceptsRuntimeInputs {
    private static final Log log = LogFactory.getLog(SimpleEmailComponent.class);
    private static final String MAILER = "smtpsend";
    private Map<String, Object> inputs;
    private String outputType;
    public static final String INPUT_TO = "to";
    public static final String INPUT_FROM = "from";
    public static final String INPUT_CC = "cc";
    public static final String INPUT_BCC = "bcc";
    public static final String INPUT_SUBJECT = "subject";
    public static final String INPUT_MESSAGEPLAIN = "message-plain";
    public static final String INPUT_MESSAGEHTML = "message-html";
    public static final String INPUT_MIMEMESSAGE = "mime-message";
    private String to;
    private String from;
    private String cc;
    private String bcc;
    private String subject;
    private Object messagePlain;
    private Object messageHtml;
    private IContentItem mimeMessage;
    private String attachmentName;
    private IContentItem attachmentContent;
    private String attachmentName2;
    private IContentItem attachmentContent2;
    private String attachmentName3;
    private IContentItem attachmentContent3;

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Object getMessageHtml() {
        return this.messageHtml;
    }

    public void setMessageHtml(Object messageHtml) {
        this.messageHtml = messageHtml;
    }

    public Object getMessagePlain() {
        return this.messagePlain;
    }

    public void setMessagePlain(Object messagePlain) {
        this.messagePlain = messagePlain;
    }

    public IContentItem getMimeMessage() {
        return this.mimeMessage;
    }

    public void setMimeMessage(IContentItem mimeMessage) {
        this.mimeMessage = mimeMessage;
    }

    public IContentItem getAttachmentContent() {
        return this.attachmentContent;
    }

    public void setAttachmentContent(IContentItem attachmentContent) {
        this.attachmentContent = attachmentContent;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public IContentItem getAttachmentContent2() {
        return this.attachmentContent2;
    }

    public void setAttachmentContent2(IContentItem attachmentContent2) {
        this.attachmentContent2 = attachmentContent2;
    }

    public IContentItem getAttachmentContent3() {
        return this.attachmentContent3;
    }

    public void setAttachmentContent3(IContentItem attachmentContent3) {
        this.attachmentContent3 = attachmentContent3;
    }

    public String getAttachmentName2() {
        return this.attachmentName2;
    }

    public void setAttachmentName2(String attachmentName2) {
        this.attachmentName2 = attachmentName2;
    }

    public String getAttachmentName3() {
        return this.attachmentName3;
    }

    public void setAttachmentName3(String attachmentName3) {
        this.attachmentName3 = attachmentName3;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
        if (inputs.containsKey(INPUT_FROM)) {
            this.setFrom((String)inputs.get(INPUT_FROM));
        }
        if (inputs.containsKey(INPUT_TO)) {
            this.setTo((String)inputs.get(INPUT_TO));
        }
        if (inputs.containsKey(INPUT_CC)) {
            this.setCc((String)inputs.get(INPUT_CC));
        }
        if (inputs.containsKey(INPUT_BCC)) {
            this.setBcc((String)inputs.get(INPUT_BCC));
        }
        if (inputs.containsKey(INPUT_SUBJECT)) {
            this.setSubject((String)inputs.get(INPUT_SUBJECT));
        }
        if (inputs.containsKey(INPUT_MESSAGEPLAIN)) {
            this.setMessagePlain((String)inputs.get(INPUT_MESSAGEPLAIN));
        }
        if (inputs.containsKey(INPUT_MESSAGEHTML)) {
            this.setMessageHtml((String)inputs.get(INPUT_MESSAGEHTML));
        }
        if (inputs.containsKey(INPUT_MIMEMESSAGE)) {
            this.setMimeMessage((IContentItem)inputs.get(INPUT_MIMEMESSAGE));
        }
    }

    protected Object getInput(String key, Object defaultValue) {
        Object input;
        if (this.inputs != null && (input = this.inputs.get(key)) != null) {
            return input;
        }
        return defaultValue;
    }

    public boolean validate() throws Exception {
        boolean result = true;
        if (this.getTo() == null) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailToNotProvided"));
            return false;
        }
        if (this.getFrom() == null) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailFromNotProvided"));
            return false;
        }
        if (this.getMessagePlain() == null && this.getMessageHtml() == null && this.getMimeMessage() == null) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailContentNotProvided"));
            result = false;
        }
        return result;
    }

    public boolean execute() throws Exception {
        try {
            Session session = this.buildSession();
            MimeMessage msg = new MimeMessage(session);
            this.applyMessageHeaders(msg);
            Multipart multipartBody = this.getMultipartBody(session);
            Multipart mainMultiPart = this.processAttachments(multipartBody);
            msg.setContent(mainMultiPart);
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (SendFailedException e) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailSendFailed"));
        }
        catch (AuthenticationFailedException e) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailAuthenticationFailed"));
        }
        return false;
    }

    private Multipart getMultipartBody(Session session) throws MessagingException, IOException {
        String content;
        MimeMultipart parentMultipart = new MimeMultipart();
        MimeBodyPart htmlBodyPart = null;
        MimeBodyPart textBodyPart = null;
        if (this.getMimeMessage() != null) {
            MimeMultipart relatedMultipart;
            MimeBodyPart original = new MimeBodyPart();
            MimeMessage originalMimeMessage = new MimeMessage(session, this.getMimeMessage().getInputStream());
            parentMultipart = relatedMultipart = (MimeMultipart)originalMimeMessage.getContent();
            htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Multipart)relatedMultipart);
        }
        if (this.getMessageHtml() != null && htmlBodyPart != null) {
            content = this.getInputString(this.getMessageHtml());
            htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Object)content, "text/html; charset=" + LocaleHelper.getSystemEncoding());
            MimeMultipart htmlMultipart = new MimeMultipart();
            htmlMultipart.addBodyPart((BodyPart)htmlBodyPart);
            parentMultipart = htmlMultipart;
        }
        if (this.getMessagePlain() != null) {
            content = this.getInputString(this.getMessagePlain());
            textBodyPart = new MimeBodyPart();
            textBodyPart.setContent((Object)content, "text/plain; charset=" + LocaleHelper.getSystemEncoding());
            MimeMultipart textMultipart = new MimeMultipart();
            textMultipart.addBodyPart((BodyPart)textBodyPart);
            parentMultipart = textMultipart;
        }
        if (htmlBodyPart != null && textBodyPart != null) {
            MimeMultipart alternative = new MimeMultipart("alternative");
            alternative.addBodyPart((BodyPart)textBodyPart);
            alternative.addBodyPart((BodyPart)htmlBodyPart);
            parentMultipart = alternative;
        }
        return parentMultipart;
    }

    private String getInputString(Object param) throws IOException {
        if (param instanceof String) {
            return (String)param;
        }
        if (param instanceof IContentItem) {
            int nextChar;
            InputStream in = ((IContentItem)param).getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((nextChar = in.read()) != -1) {
                out.write(nextChar);
            }
            return new String(out.toString(LocaleHelper.getSystemEncoding()));
        }
        throw new IllegalStateException("Input is not a String or ContentItem");
    }

    private Multipart processAttachments(Multipart multipartBody) throws MessagingException, IOException {
        if (this.getAttachmentContent() == null) {
            return multipartBody;
        }
        MimeMultipart mixedMultipart = new MimeMultipart("mixed");
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent(multipartBody);
        mixedMultipart.addBodyPart((BodyPart)bodyPart);
        this.processSpecificAttachment(mixedMultipart, this.getAttachmentContent());
        this.processSpecificAttachment(mixedMultipart, this.getAttachmentContent2());
        this.processSpecificAttachment(mixedMultipart, this.getAttachmentContent3());
        return mixedMultipart;
    }

    private void processSpecificAttachment(MimeMultipart mixedMultipart, IContentItem attachmentContent) throws IOException, MessagingException {
        if (attachmentContent != null) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(attachmentContent.getInputStream(), attachmentContent.getMimeType());
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            attachmentBodyPart.setFileName(this.getAttachmentName());
            mixedMultipart.addBodyPart((BodyPart)attachmentBodyPart);
        }
    }

    private void applyMessageHeaders(MimeMessage msg) throws Exception {
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        if (this.cc != null && this.cc.trim().length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc, (boolean)false));
        }
        if (this.bcc != null && this.bcc.trim().length() > 0) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc, (boolean)false));
        }
        if (this.subject != null) {
            msg.setSubject(this.subject, LocaleHelper.getSystemEncoding());
        }
    }

    private Session buildSession() throws Exception {
        Session session;
        Properties props = new Properties();
        try {
            Document configDocument = PentahoSystem.getSystemSettings().getSystemSettingsDocument("smtp-email/email_config.xml");
            List properties = configDocument.selectNodes("/email-smtp/properties/*");
            for (Node propertyNode : properties) {
                String propertyName = propertyNode.getName();
                String propertyValue = propertyNode.getText();
                props.put(propertyName, propertyValue);
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getString("ReportPlugin.emailConfigFileInvalid"));
            throw e;
        }
        boolean authenticate = "true".equals(props.getProperty("mail.smtp.auth"));
        if (authenticate) {
            EmailAuthenticator authenticator = new EmailAuthenticator();
            session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        } else {
            session = Session.getInstance((Properties)props);
        }
        if (!props.containsKey("mail.debug")) {
            session.setDebug(true);
        }
        return session;
    }

    public String getMimeType() {
        return this.outputType;
    }

    private static class EmailAuthenticator
    extends Authenticator {
        private EmailAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String user = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.userid", null);
            String password = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.password", null);
            return new PasswordAuthentication(user, password);
        }
    }
}

