/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;

public class ReportingConfiguration
extends PropertyLookupParser
implements Configuration {
    private static final long serialVersionUID = -1191667017348135395L;
    private DefaultConfiguration config;

    public ReportingConfiguration() {
        this.setOpeningBraceChar('(');
        this.setClosingBraceChar(')');
        this.config = new DefaultConfiguration();
        ISystemSettings cfg = PentahoSystem.getSystemSettings();
        if (cfg == null) {
            return;
        }
        List reportSettings = cfg.getSystemSettings("report-config/entry");
        for (int i = 0; i < reportSettings.size(); ++i) {
            Element element = (Element)reportSettings.get(i);
            Attribute name = element.attribute("name");
            Attribute value = element.attribute("value");
            if (name == null || value == null) continue;
            this.config.setConfigProperty(name.getValue(), this.translateAndLookup(value.getValue()));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReportingConfiguration cfg = (ReportingConfiguration)((Object)super.clone());
        cfg.config = (DefaultConfiguration)cfg.clone();
        return cfg;
    }

    public Iterator findPropertyKeys(String prefix) {
        return this.config.findPropertyKeys(prefix);
    }

    public Enumeration getConfigProperties() {
        return this.config.getConfigProperties();
    }

    public String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    public String getConfigProperty(String key, String defaultvalue) {
        return this.config.getConfigProperty(key, defaultvalue);
    }

    protected String lookupVariable(String property) {
        String globalParam;
        String contextParam;
        IApplicationContext context = PentahoSystem.getApplicationContext();
        if (context != null && (contextParam = context.getProperty(property)) != null) {
            return contextParam;
        }
        IParameterProvider globalParameters = PentahoSystem.getGlobalParameters();
        if (globalParameters != null && (globalParam = globalParameters.getStringParameter(property, null)) != null) {
            return globalParam;
        }
        String systemSetting = PentahoSystem.getSystemSetting((String)property, null);
        if (systemSetting != null) {
            return systemSetting;
        }
        if (context != null && "base-url".equals(property)) {
            return context.getFullyQualifiedServerURL();
        }
        return null;
    }
}

