/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.plugin.jfreereport.reportcharts.ChartExpression;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContextWrapper;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.StaticListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.libraries.base.util.NullOutputStream;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.DataTable;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.platform.plugin.CommonUtil;
import org.pentaho.reporting.platform.plugin.ParameterContentGenerator;
import org.pentaho.reporting.platform.plugin.ParameterDependencyGraph;
import org.pentaho.reporting.platform.plugin.ReportContentUtil;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.FastExportReportOutputHandlerFactory;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerFactory;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterXmlContentHandler {
    public static final String SYS_PARAM_ACCEPTED_PAGE = "accepted-page";
    public static final String SYS_PARAM_RENDER_MODE = "renderMode";
    public static final String SYS_PARAM_CONTENT_LINK = "::cl";
    public static final String SYS_PARAM_SESSION_ID = "::session";
    public static final String SYS_SERVER_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/server";
    private static final Log logger = LogFactory.getLog(ParameterXmlContentHandler.class);
    private static final String SYS_PARAM_OUTPUT_TARGET = "output-target";
    private static final String SYS_PARAM_DESTINATION = "destination";
    private static final String GROUP_SYSTEM = "system";
    private static final String GROUP_PARAMETERS = "parameters";
    private static final String SYS_PARAM_TAB_NAME = "::TabName";
    private static final String SYS_PARAM_TAB_ACTIVE = "::TabActive";
    private static final String SYS_IGNORE_PARAM = "::org.pentaho.reporting";
    private static final String SYS_PARAM_HTML_PROPORTIONAL_WIDTH = "htmlProportionalWidth";
    private static final String CONFIG_PARAM_HTML_PROPORTIONAL_WIDTH = "org.pentaho.reporting.engine.classic.core.modules.output.table.html.ProportionalColumnWidths";
    private static final String SYS_PARAM_IS_QUERY_CONTROL_ENABLED = "query-limit-ui-enabled";
    private static final String SYS_PARAM_REPORT_QUERY_LIMIT = "report-query-limit";
    static final String SYS_PARAM_QUERY_LIMIT = "query-limit";
    private static final String SYS_PARAM_MAX_QUERY_LIMIT = "maximum-query-limit";
    Document document;
    private Map<String, ParameterDefinitionEntry> systemParameter;
    private final boolean paginate;
    private final IParameterProvider requestParameters;
    private final Map<String, Object> inputs;

    public ParameterXmlContentHandler(ParameterContentGenerator contentGenerator, boolean paginate) {
        this.paginate = paginate;
        this.inputs = contentGenerator.createInputs();
        this.requestParameters = contentGenerator.getRequestParameters();
    }

    public static String convertParameterValueToString(ParameterDefinitionEntry parameter, ParameterContext context, Object value, Class<?> type) throws BeanException {
        Object[] o;
        if (value == null) {
            return null;
        }
        if (value instanceof Object[] && (o = (Object[])value).length == 1) {
            return String.valueOf(o[0]);
        }
        if (value instanceof String[]) {
            o = (String[])value;
            return org.apache.commons.lang.StringUtils.join((Object[])o, (char)'|');
        }
        ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(type);
        if (valueConverter == null) {
            return String.valueOf(value);
        }
        if (Date.class.isAssignableFrom(type)) {
            SimpleDateFormat dateFormat;
            if (!(value instanceof Date)) {
                throw new BeanException(Messages.getInstance().getString("ReportPlugin.errorNonDateParameterValue"));
            }
            String timezone = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", context);
            if (timezone == null || "server".equals(timezone) || "client".equals(timezone)) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            } else {
                TimeZone timeZoneObject = "utc".equals(timezone) ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timezone);
                dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                dateFormat.setTimeZone(timeZoneObject);
            }
            Date d = (Date)value;
            return dateFormat.format(d);
        }
        if (Number.class.isAssignableFrom(type)) {
            ValueConverter numConverter = ConverterRegistry.getInstance().getValueConverter(BigDecimal.class);
            return numConverter.toAttributeValue((Object)new BigDecimal(String.valueOf(value)));
        }
        return valueConverter.toAttributeValue(value);
    }

    private static void appendPageCount(SimpleReportingComponent reportComponent, Element parameters) throws Exception {
        reportComponent.setOutputStream((OutputStream)new NullOutputStream());
        int acceptedPage = reportComponent.getAcceptedPage();
        reportComponent.setAcceptedPage(-1);
        if (reportComponent.validate()) {
            if (!reportComponent.outputSupportsPagination()) {
                return;
            }
            int totalPageCount = reportComponent.paginate();
            parameters.setAttribute("paginate", "true");
            parameters.setAttribute("page-count", String.valueOf(totalPageCount));
            parameters.setAttribute(SYS_PARAM_ACCEPTED_PAGE, String.valueOf(acceptedPage));
        }
    }

    private IParameterProvider getRequestParameters() {
        return this.requestParameters;
    }

    private Map<String, ParameterDefinitionEntry> getSystemParameter() {
        if (this.systemParameter == null) {
            LinkedHashMap<String, Object> parameter = new LinkedHashMap<String, Object>();
            parameter.put(SYS_PARAM_OUTPUT_TARGET, this.createOutputParameter());
            parameter.put(SYS_PARAM_CONTENT_LINK, this.createContentLinkingParameter());
            parameter.put(SYS_PARAM_TAB_NAME, this.createGenericSystemParameter(SYS_PARAM_TAB_NAME, false, true));
            parameter.put(SYS_PARAM_TAB_ACTIVE, this.createGenericBooleanSystemParameter(SYS_PARAM_TAB_ACTIVE, false, true));
            parameter.put("yield-rate", this.createGenericIntSystemParameter("yield-rate", false, false));
            parameter.put(SYS_PARAM_ACCEPTED_PAGE, this.createGenericIntSystemParameter(SYS_PARAM_ACCEPTED_PAGE, false, false));
            parameter.put(SYS_PARAM_SESSION_ID, this.createGenericSystemParameter(SYS_PARAM_SESSION_ID, false, false));
            parameter.put("path", this.createGenericSystemParameter("path", false, false));
            parameter.put("id", this.createGenericSystemParameter("id", false, false));
            parameter.put("output-type", this.createGenericSystemParameter("output-type", true, false));
            parameter.put("layout", this.createGenericSystemParameter("layout", true, false));
            parameter.put("content-handler-pattern", this.createGenericSystemParameter("content-handler-pattern", true, false));
            parameter.put("autoSubmit", this.createGenericBooleanSystemParameter("autoSubmit", true, true));
            parameter.put("autoSubmitUI", this.createGenericBooleanSystemParameter("autoSubmitUI", true, true));
            parameter.put("dashboard-mode", this.createGenericBooleanSystemParameter("dashboard-mode", false, true));
            parameter.put("showParameters", this.createGenericBooleanSystemParameter("showParameters", true, true));
            parameter.put("paginate", this.createGenericBooleanSystemParameter("paginate", true, false));
            parameter.put("ignoreDefaultDates", this.createGenericBooleanSystemParameter("ignoreDefaultDates", true, false));
            parameter.put("print", this.createGenericBooleanSystemParameter("print", false, false));
            parameter.put("printer-name", this.createGenericSystemParameter("printer-name", false, false));
            parameter.put(SYS_PARAM_RENDER_MODE, this.createRenderModeSystemParameter());
            parameter.put(SYS_PARAM_HTML_PROPORTIONAL_WIDTH, this.createGenericBooleanSystemParameter(SYS_PARAM_HTML_PROPORTIONAL_WIDTH, false, true));
            parameter.put(SYS_PARAM_IS_QUERY_CONTROL_ENABLED, this.createGenericBooleanSystemParameter(SYS_PARAM_IS_QUERY_CONTROL_ENABLED, false, false));
            parameter.put(SYS_PARAM_QUERY_LIMIT, this.createGenericIntSystemParameter(SYS_PARAM_QUERY_LIMIT, false, false));
            parameter.put(SYS_PARAM_MAX_QUERY_LIMIT, this.createGenericIntSystemParameter(SYS_PARAM_MAX_QUERY_LIMIT, false, false));
            this.systemParameter = Collections.unmodifiableMap(parameter);
        }
        return this.systemParameter;
    }

    private boolean isGenerateDefaultDates() {
        Object value = this.inputs.get("ignoreDefaultDates");
        if (value == null) {
            return false;
        }
        return "true".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createParameterContent(OutputStream outputStream, Serializable fileId, String path, boolean overrideOutputType, MasterReport sourceReport) throws Exception {
        Object rawSessionId = this.inputs.get(SYS_PARAM_SESSION_ID);
        if (!(rawSessionId instanceof String) || "".equals(rawSessionId)) {
            this.inputs.put(SYS_PARAM_SESSION_ID, UUIDUtil.getUUIDAsString());
        }
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        IParameterProvider requestParams = this.getRequestParameters();
        SimpleReportingComponent reportComponent = new SimpleReportingComponent();
        reportComponent.setReportFileId(fileId);
        if (sourceReport != null) {
            reportComponent.setReport(sourceReport);
        }
        reportComponent.setPaginateOutput(true);
        boolean isMobile = "true".equals(requestParams.getStringParameter("mobile", "false"));
        if (isMobile) {
            overrideOutputType = true;
            reportComponent.setForceDefaultOutputTarget(true);
        } else {
            reportComponent.setForceDefaultOutputTarget(overrideOutputType);
        }
        reportComponent.setDefaultOutputTarget("table/html;page-mode=page");
        if (path.endsWith(".prpti") && requestParams.getParameter("json") == null) {
            reportComponent.setForceUnlockPreferredOutput(true);
        }
        reportComponent.setInputs(this.inputs);
        MasterReport report = reportComponent.getReport();
        try (DefaultParameterContext parameterContext = new DefaultParameterContext(report);){
            ValidationResult validationResult = ReportContentUtil.applyInputsToReportParameters(report, (ParameterContext)parameterContext, this.inputs, new ValidationResult());
            ReportParameterDefinition reportParameterDefinition = report.getParameterDefinition();
            ValidationResult vr = reportParameterDefinition.getValidator().validate(validationResult, reportParameterDefinition, (ParameterContext)parameterContext);
            Element parameters = this.document.createElement(GROUP_PARAMETERS);
            parameters.setAttribute("is-prompt-needed", String.valueOf(!vr.isEmpty()));
            parameters.setAttribute("ignore-biserver-5538", "true");
            Boolean autoSubmitFlag = this.requestFlag("autoSubmit", report, "http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-parameter", "org.pentaho.reporting.engine.classic.core.ParameterAutoSubmit");
            if (Boolean.TRUE.equals(autoSubmitFlag)) {
                parameters.setAttribute("autoSubmit", "true");
            } else if (Boolean.FALSE.equals(autoSubmitFlag)) {
                parameters.setAttribute("autoSubmit", "false");
            }
            Boolean autoSubmitUiFlag = this.requestFlag("autoSubmitUI", report, "http://reporting.pentaho.org/namespaces/engine/attributes/core", "auto-submit-default", "org.pentaho.reporting.engine.classic.core.ParameterAutoSubmitUI");
            if (Boolean.FALSE.equals(autoSubmitUiFlag)) {
                parameters.setAttribute("autoSubmitUI", "false");
            } else {
                parameters.setAttribute("autoSubmitUI", "true");
            }
            parameters.setAttribute("layout", this.requestConfiguration("layout", report, "http://reporting.pentaho.org/namespaces/engine/attributes/core", "parameter-layout", "org.pentaho.reporting.engine.classic.core.ParameterUiLayout"));
            LinkedHashMap<String, ParameterDefinitionEntry> reportParameters = this.collectParameterEntries(reportParameterDefinition);
            if (overrideOutputType) {
                ParameterDefinitionEntry definitionEntry = reportParameters.get(SYS_PARAM_OUTPUT_TARGET);
                if (definitionEntry instanceof AbstractParameter) {
                    AbstractParameter parameter = (AbstractParameter)definitionEntry;
                    parameter.setHidden(true);
                    parameter.setMandatory(false);
                }
            } else {
                this.hideOutputParameterIfLocked(report, reportParameters);
            }
            Map<String, Object> inputs = this.computeParameterValueSet(reportComponent, (ParameterContext)parameterContext, vr, reportParameters);
            String[] changedParamsQuery = requestParams.getStringArrayParameter("changedParameters", new String[0]);
            HashSet<String> changedParams = new HashSet<String>(Arrays.asList(changedParamsQuery));
            ParameterDependencyGraph dependencies = new ParameterDependencyGraph(report, reportParameters, (ParameterContext)parameterContext, inputs);
            this.appendParametersList(parameterContext, vr, parameters, dependencies, reportParameters, inputs, changedParams);
            this.appendErrorMessages(vr, parameters);
            this.appendOutputParameter(report, parameters);
            if (vr.isEmpty() && this.paginate && reportComponent.getComputedOutputTarget().equals("table/html;page-mode=page")) {
                ParameterXmlContentHandler.appendPageCount(reportComponent, parameters);
            }
            this.document.appendChild(parameters);
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
    }

    private void appendErrorMessages(ValidationResult vr, Element parameters) {
        if (!vr.isEmpty()) {
            parameters.appendChild(this.createErrorElements(vr));
        }
    }

    private void appendOutputParameter(MasterReport report, Element parameters) {
        String[] outputParameter;
        for (String outputParameterName : outputParameter = new OutputParameterCollector().collectParameter(report)) {
            Element element = this.document.createElement("output-parameter");
            element.setAttribute("displayName", outputParameterName);
            element.setAttribute("id", outputParameterName);
            parameters.appendChild(element);
        }
    }

    private Map<String, Object> computeParameterValueSet(SimpleReportingComponent reportComponent, ParameterContext parameterContext, ValidationResult vr, Map<String, ParameterDefinitionEntry> parameterSet) throws IOException, ResourceException {
        MasterReport report = reportComponent.getReport();
        Map<String, Object> inputs = this.computeRealInput(parameterContext, parameterSet, reportComponent.getComputedOutputTarget(), vr);
        Boolean showParameterUI = this.requestFlag("showParameters", report, "http://reporting.pentaho.org/namespaces/engine/attributes/core", "show-parameter-ui", null);
        if (Boolean.FALSE.equals(showParameterUI)) {
            inputs.put("showParameters", Boolean.FALSE);
        } else {
            inputs.put("showParameters", Boolean.TRUE);
        }
        String proportionalWidth = reportComponent.getReport().getReportConfiguration().getConfigProperty(CONFIG_PARAM_HTML_PROPORTIONAL_WIDTH);
        inputs.put(SYS_PARAM_HTML_PROPORTIONAL_WIDTH, Boolean.valueOf(proportionalWidth));
        inputs.putAll(this.computeQueryControlParameterSet(report));
        return inputs;
    }

    private Map<String, Object> computeQueryControlParameterSet(MasterReport report) {
        Boolean isQueryLimitControlEnabled = false;
        Integer maxQueryLimit = null;
        IPluginManager pm = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (pm != null) {
            isQueryLimitControlEnabled = Boolean.parseBoolean((String)pm.getPluginSetting("reporting", "settings/query-limit-ui-enabled", "false"));
            Expression expression = report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", SYS_PARAM_QUERY_LIMIT);
            if (expression != null) {
                isQueryLimitControlEnabled = false;
            }
            maxQueryLimit = isQueryLimitControlEnabled != false ? NumberUtils.toInt((String)((String)pm.getPluginSetting("reporting", "settings/query-limit", "0")), (int)0) : 0;
        }
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(SYS_PARAM_IS_QUERY_CONTROL_ENABLED, isQueryLimitControlEnabled);
        inputs.put(SYS_PARAM_REPORT_QUERY_LIMIT, report.getQueryLimit());
        inputs.put(SYS_PARAM_QUERY_LIMIT, report.getQueryLimit());
        inputs.put(SYS_PARAM_MAX_QUERY_LIMIT, maxQueryLimit);
        return inputs;
    }

    private LinkedHashMap<String, ParameterDefinitionEntry> collectParameterEntries(ReportParameterDefinition reportParameterDefinition) {
        ParameterDefinitionEntry[] parameterDefinitions = reportParameterDefinition.getParameterDefinitions();
        LinkedHashMap<String, ParameterDefinitionEntry> reportParameters = new LinkedHashMap<String, ParameterDefinitionEntry>();
        for (ParameterDefinitionEntry parameter : parameterDefinitions) {
            reportParameters.put(parameter.getName(), parameter);
        }
        for (Map.Entry entry : this.getSystemParameter().entrySet()) {
            if (reportParameters.containsKey(entry.getKey())) continue;
            reportParameters.put((String)entry.getKey(), (ParameterDefinitionEntry)entry.getValue());
        }
        return reportParameters;
    }

    protected void appendParametersList(DefaultParameterContext parameterContext, ValidationResult vr, Element parameters, ParameterDependencyGraph dependencies, LinkedHashMap<String, ParameterDefinitionEntry> reportParameters, Map<String, Object> inputs, Set<String> changedParameters) throws CloneNotSupportedException, BeanException, ReportDataFactoryException {
        if (!changedParameters.isEmpty()) {
            HashSet<String> changedWithDependencies = new HashSet<String>(changedParameters);
            changedWithDependencies.addAll(dependencies.getAllDependencies(changedParameters));
            List<ParameterDefinitionEntry> changedParamDefinitions = reportParameters.values().stream().filter(p -> changedWithDependencies.contains(p.getName())).collect(Collectors.toList());
            Set<String> effectivelyChanged = this.filterRedundantParameter(changedParameters, dependencies);
            this.renderParameters(parameterContext, vr, parameters, dependencies, changedParamDefinitions, effectivelyChanged, inputs, true);
            parameters.setAttribute("minimized", "true");
        } else {
            this.renderParameters(parameterContext, vr, parameters, dependencies, reportParameters.values(), Collections.emptySet(), inputs, false);
        }
    }

    protected void renderParameters(DefaultParameterContext parameterContext, ValidationResult vr, Element parameters, ParameterDependencyGraph dependencies, Collection<ParameterDefinitionEntry> reportParameters, Set<String> changedParameters, Map<String, Object> inputs, boolean ignoreAttributes) throws BeanException, ReportDataFactoryException {
        for (ParameterDefinitionEntry parameter : reportParameters) {
            Object selections = this.getSelections(parameter, changedParameters, inputs);
            ParameterContextWrapper wrapper = new ParameterContextWrapper((ParameterContext)parameterContext, (DataRow)vr.getParameterValues());
            Element el = this.createParameterElement(parameter, (ParameterContext)wrapper, selections, dependencies, ignoreAttributes);
            if (!ignoreAttributes) {
                this.createParameterDependencies(el, parameter, dependencies);
            }
            parameters.appendChild(el);
        }
    }

    protected Object getSelections(ParameterDefinitionEntry parameter, Set<String> changedParameters, Map<String, Object> inputs) {
        Objects.requireNonNull(changedParameters);
        Objects.requireNonNull(parameter);
        Objects.requireNonNull(inputs);
        String pName = parameter.getName();
        if (changedParameters.isEmpty()) {
            return inputs.get(pName);
        }
        if (!(parameter instanceof ListParameter)) {
            return inputs.get(pName);
        }
        ListParameter listParameter = (ListParameter)parameter;
        boolean isVerifiedValue = listParameter.isStrictValueCheck();
        boolean ifChangedParameter = changedParameters.contains(pName);
        return isVerifiedValue || ifChangedParameter ? inputs.get(pName) : null;
    }

    private Set<String> filterRedundantParameter(Set<String> changedParameters, ParameterDependencyGraph dependencies) {
        if (changedParameters.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> effectivelyChanged = new HashSet<String>(changedParameters);
        for (String knownParameter : dependencies.getKnownParameter()) {
            if (!changedParameters.contains(knownParameter)) continue;
            for (String child : dependencies.getDependentParameterFor(knownParameter)) {
                effectivelyChanged.remove(child);
            }
        }
        return effectivelyChanged;
    }

    private Map<String, Object> computeRealInput(ParameterContext parameterContext, Map<String, ParameterDefinitionEntry> reportParameters, String computedOutputTarget, ValidationResult result) {
        HashMap<String, Object> realInputs = new HashMap<String, Object>();
        realInputs.put(SYS_PARAM_DESTINATION, this.lookupDestination());
        ReportParameterValues parameterValues = result.getParameterValues();
        for (ParameterDefinitionEntry parameter : reportParameters.values()) {
            String parameterName = parameter.getName();
            Object parameterFromReport = parameterValues.get(parameterName);
            if (parameterFromReport != null) {
                realInputs.put(parameterName, parameterFromReport);
                continue;
            }
            Object value = this.inputs.get(parameterName);
            if (value == null) {
                realInputs.put(parameterName, null);
                continue;
            }
            try {
                Object translatedValue = ReportContentUtil.computeParameterValue(parameterContext, parameter, value);
                if (translatedValue != null) {
                    realInputs.put(parameterName, translatedValue);
                    continue;
                }
                realInputs.put(parameterName, null);
            }
            catch (Exception be) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)Messages.getInstance().getString("ReportPlugin.debugParameterCannotBeConverted", new Object[]{parameter.getName(), String.valueOf(value)}), (Throwable)be);
            }
        }
        realInputs.put(SYS_PARAM_OUTPUT_TARGET, computedOutputTarget);
        return realInputs;
    }

    private void hideOutputParameterIfLocked(MasterReport report, Map<String, ParameterDefinitionEntry> reportParameters) {
        boolean lockOutputType = Boolean.TRUE.equals(report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "lock-preferred-output-type"));
        ParameterDefinitionEntry definitionEntry = reportParameters.get(SYS_PARAM_OUTPUT_TARGET);
        if (definitionEntry instanceof AbstractParameter) {
            AbstractParameter parameter = (AbstractParameter)definitionEntry;
            parameter.setHidden(lockOutputType);
            parameter.setMandatory(!lockOutputType);
        }
    }

    void createParameterDependencies(Element element, ParameterDefinitionEntry parameter, ParameterDependencyGraph dependencies) {
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(parameter, "parameter");
        Objects.requireNonNull(dependencies, "dependencies");
        if (!dependencies.getKnownParameter().contains(parameter.getName())) {
            return;
        }
        Element valuesElement = this.document.createElement("dependencies");
        for (String dependency : dependencies.getAllDependencies(parameter.getName())) {
            Element name = this.document.createElement("name");
            name.setTextContent(dependency);
            valuesElement.appendChild(name);
        }
        element.appendChild(valuesElement);
    }

    private boolean shouldAlwaysValidateOnServer(ParameterDefinitionEntry parameter, ParameterContext parameterContext) {
        if (this.isTextFieldButNotString(parameter, parameterContext)) {
            return true;
        }
        String postProcessorFormula = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "post-processor-formula", parameterContext);
        if (!StringUtils.isEmpty((String)postProcessorFormula)) {
            return true;
        }
        if ("true".equals(parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "re-evaluate-on-failed-values", parameterContext))) {
            return true;
        }
        return "true".equals(parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection", parameterContext));
    }

    Element createParameterElement(ParameterDefinitionEntry parameter, ParameterContext parameterContext, Object selections, ParameterDependencyGraph dependencies, boolean ignoreAttributes) throws BeanException, ReportDataFactoryException {
        try {
            Element parameterElement = this.document.createElement("parameter");
            parameterElement.setAttribute("name", parameter.getName());
            Class<?> valueType = parameter.getValueType();
            parameterElement.setAttribute("type", valueType.getName());
            parameterElement.setAttribute("is-mandatory", String.valueOf(parameter.isMandatory()));
            String[] namespaces = parameter.getParameterAttributeNamespaces();
            if (!ignoreAttributes) {
                for (String namespace : namespaces) {
                    String[] attributeNames;
                    for (String attributeName : attributeNames = parameter.getParameterAttributeNames(namespace)) {
                        String attributeValue = parameter.getTranslatedParameterAttribute(namespace, attributeName, parameterContext);
                        Element attributeElement = this.document.createElement("attribute");
                        attributeElement.setAttribute("namespace", namespace);
                        attributeElement.setAttribute("name", attributeName);
                        attributeElement.setAttribute("value", attributeValue);
                        parameterElement.appendChild(attributeElement);
                    }
                }
                boolean shouldValidateOnServer = !dependencies.isNoDependencyInformationAvailable() || this.shouldAlwaysValidateOnServer(parameter, parameterContext);
                Set<String> dependentParams = dependencies.getDependentParameterFor(parameter.getName());
                if (!dependentParams.isEmpty()) {
                    Element oneMoreAttribute = this.document.createElement("attribute");
                    oneMoreAttribute.setAttribute("namespace", SYS_SERVER_NAMESPACE);
                    oneMoreAttribute.setAttribute("name", "has-downstream-dependent-parameter");
                    oneMoreAttribute.setAttribute("value", Boolean.TRUE.toString());
                    parameterElement.appendChild(oneMoreAttribute);
                    shouldValidateOnServer = true;
                }
                if (shouldValidateOnServer) {
                    Element attrElement = this.document.createElement("attribute");
                    attrElement.setAttribute("namespace", SYS_SERVER_NAMESPACE);
                    attrElement.setAttribute("name", "must-validate-on-server");
                    attrElement.setAttribute("value", Boolean.TRUE.toString());
                    parameterElement.appendChild(attrElement);
                }
            }
            Class<?> elementValueType = valueType.isArray() ? valueType.getComponentType() : valueType;
            LinkedHashSet<Object> selectionSet = this.computeSelectionSet(parameter, parameterContext, selections, valueType);
            if (Date.class.isAssignableFrom(elementValueType)) {
                parameterElement.setAttribute("timezone-hint", this.computeTimeZoneHint(parameter, parameterContext, selectionSet));
            }
            LinkedHashSet handledValues = (LinkedHashSet)selectionSet.clone();
            if (parameter instanceof ListParameter) {
                ListParameter asListParam = (ListParameter)parameter;
                parameterElement.setAttribute("is-multi-select", String.valueOf(asListParam.isAllowMultiSelection()));
                parameterElement.setAttribute("is-strict", String.valueOf(asListParam.isStrictValueCheck()));
                parameterElement.setAttribute("is-list", "true");
                Element valuesElement = this.document.createElement("values");
                parameterElement.appendChild(valuesElement);
                ParameterValues possibleValues = asListParam.getValues(parameterContext);
                for (int i = 0; i < possibleValues.getRowCount(); ++i) {
                    Object origKey;
                    Object key = possibleValues.getKeyValue(i);
                    Object value = possibleValues.getTextValue(i);
                    Element valueElement = this.document.createElement("value");
                    valuesElement.appendChild(valueElement);
                    if (this.hasISOControlChars(key, elementValueType) || this.hasISOControlChars(value, elementValueType)) {
                        key = Base64.encodeBase64String((byte[])key.toString().getBytes());
                        value = Base64.encodeBase64String((byte[])value.toString().getBytes());
                        valueElement.setAttribute("encoded", "true");
                    }
                    valueElement.setAttribute("label", HtmlUtils.htmlEscape((String)String.valueOf(value)));
                    valueElement.setAttribute("type", elementValueType.getName());
                    if (key instanceof Number) {
                        BigDecimal bd = new BigDecimal(String.valueOf(key));
                        valueElement.setAttribute("selected", String.valueOf(selectionSet.contains(bd)));
                        handledValues.remove(bd);
                    } else if (key instanceof Timestamp) {
                        origKey = (Timestamp)possibleValues.getKeyValue(i);
                        valueElement.setAttribute("selected", String.valueOf(selectionSet.contains(new Date(((Timestamp)origKey).getTime()))));
                        handledValues.remove(key);
                    } else if (key == null) {
                        if (selections == null || selectionSet.contains(null)) {
                            valueElement.setAttribute("selected", "true");
                            handledValues.remove(null);
                        }
                    } else {
                        origKey = possibleValues.getKeyValue(i);
                        valueElement.setAttribute("selected", String.valueOf(selectionSet.contains(origKey)));
                        handledValues.remove(key);
                    }
                    if (key == null) {
                        valueElement.setAttribute("null", "true");
                        continue;
                    }
                    valueElement.setAttribute("null", "false");
                    valueElement.setAttribute("value", ParameterXmlContentHandler.convertParameterValueToString(parameter, parameterContext, key, elementValueType));
                }
                if (!asListParam.isStrictValueCheck()) {
                    for (Object key : handledValues) {
                        Element valueElement = this.document.createElement("value");
                        valuesElement.appendChild(valueElement);
                        valueElement.setAttribute("label", Messages.getInstance().getString("ReportPlugin.autoParameter", new Object[]{String.valueOf(key)}));
                        valueElement.setAttribute("type", elementValueType.getName());
                        if (key instanceof Number) {
                            BigDecimal bd = new BigDecimal(String.valueOf(key));
                            valueElement.setAttribute("selected", String.valueOf(selectionSet.contains(bd)));
                        } else {
                            valueElement.setAttribute("selected", String.valueOf(selectionSet.contains(key)));
                        }
                        if (key == null) {
                            valueElement.setAttribute("null", "true");
                            continue;
                        }
                        valueElement.setAttribute("null", "false");
                        valueElement.setAttribute("value", ParameterXmlContentHandler.convertParameterValueToString(parameter, parameterContext, key, elementValueType));
                    }
                }
            } else if (parameter instanceof PlainParameter) {
                parameterElement.setAttribute("is-multi-select", "false");
                parameterElement.setAttribute("is-strict", "false");
                parameterElement.setAttribute("is-list", "false");
                if (selections != null) {
                    Element valuesElement = this.document.createElement("values");
                    parameterElement.appendChild(valuesElement);
                    Element valueElement = this.document.createElement("value");
                    valuesElement.appendChild(valueElement);
                    valueElement.setAttribute("type", valueType.getName());
                    valueElement.setAttribute("selected", "true");
                    valueElement.setAttribute("null", "false");
                    String value = ParameterXmlContentHandler.convertParameterValueToString(parameter, parameterContext, selections, valueType);
                    valueElement.setAttribute("value", value);
                    valueElement.setAttribute("label", HtmlUtils.htmlEscape((String)value));
                }
            }
            return parameterElement;
        }
        catch (BeanException be) {
            logger.error((Object)Messages.getInstance().getString("ReportPlugin.errorFailedToGenerateParameter", new Object[]{parameter.getName(), String.valueOf(selections)}), (Throwable)be);
            throw be;
        }
    }

    private LinkedHashSet<Object> computeSelectionSet(ParameterDefinitionEntry parameter, ParameterContext parameterContext, Object selections, Class<?> valueType) {
        LinkedHashSet<Object> selectionSet = new LinkedHashSet<Object>();
        if (selections != null) {
            if (selections.getClass().isArray()) {
                int length = Array.getLength(selections);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(selections, i);
                    selectionSet.add(this.resolveSelectionValue(value));
                }
            } else {
                selectionSet.add(this.resolveSelectionValue(selections));
            }
        } else {
            String type = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", parameterContext);
            if ("datepicker".equals(type) && Date.class.isAssignableFrom(valueType) && this.isGenerateDefaultDates()) {
                selectionSet.add(new Date());
            }
        }
        return selectionSet;
    }

    private boolean isTextFieldButNotString(ParameterDefinitionEntry parameter, ParameterContext pc) {
        Class valueType = parameter.getValueType();
        String displayType = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", pc);
        if ("textbox".equals(displayType) || "multi-line".equals(displayType)) {
            return !String.class.equals((Object)valueType);
        }
        return false;
    }

    private boolean hasISOControlChars(Object value, Class<?> type) {
        if (value == null) {
            return false;
        }
        if (type == String.class) {
            String string = value.toString();
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isISOControl(string.charAt(i))) continue;
                return true;
            }
            return false;
        }
        if (type == Character.class) {
            return Character.isISOControl(((Character)value).charValue());
        }
        return false;
    }

    private Object resolveSelectionValue(Object value) {
        if (value instanceof Number) {
            return new BigDecimal(String.valueOf(value.toString()));
        }
        return value;
    }

    private String computeTimeZoneHint(ParameterDefinitionEntry parameter, ParameterContext parameterContext, LinkedHashSet<Object> selectionSet) {
        int offset;
        String timezoneSpec = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", parameterContext);
        if ("client".equals(timezoneSpec)) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        TimeZone timeZone = timezoneSpec == null || "server".equals(timezoneSpec) ? TimeZone.getDefault() : ("utc".equals(timezoneSpec) ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timezoneSpec));
        if (selectionSet != null && selectionSet.size() > 0) {
            Date date = (Date)selectionSet.iterator().next();
            offset = timeZone.getOffset(date.getTime());
        } else {
            offset = timeZone.getRawOffset();
        }
        if (offset < 0) {
            value.append("-");
        } else {
            value.append("\\+");
        }
        int seconds = Math.abs(offset / 1000);
        int minutesRaw = seconds / 60;
        int hours = minutesRaw / 60;
        int minutes = minutesRaw % 60;
        if (hours < 10) {
            value.append("0");
        }
        value.append(hours);
        if (minutes < 10) {
            value.append("0");
        }
        value.append(minutes);
        return value.toString();
    }

    Element createErrorElements(ValidationResult vr) {
        ValidationMessage[] globalMessages;
        Element errors = this.document.createElement("errors");
        for (String property : vr.getProperties()) {
            for (ValidationMessage message : vr.getErrors(property)) {
                Element error = this.document.createElement("error");
                error.setAttribute("parameter", property);
                error.setAttribute("message", message.getMessage());
                errors.appendChild(error);
            }
        }
        for (ValidationMessage globalMessage : globalMessages = vr.getErrors()) {
            Element error = this.document.createElement("global-error");
            error.setAttribute("message", globalMessage.getMessage());
            errors.appendChild(error);
        }
        return errors;
    }

    private PlainParameter createGenericSystemParameter(String parameterName, boolean deprecated, boolean preferredParameter) {
        return this.createGenericSystemParameter(parameterName, deprecated, preferredParameter, String.class);
    }

    private PlainParameter createGenericSystemParameter(String parameterName, boolean deprecated, boolean preferredParameter, Class<?> type) {
        PlainParameter destinationParameter = new PlainParameter(parameterName, type);
        destinationParameter.setMandatory(false);
        destinationParameter.setHidden(true);
        destinationParameter.setRole(GROUP_SYSTEM);
        destinationParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "preferred", String.valueOf(preferredParameter));
        destinationParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group", GROUP_SYSTEM);
        destinationParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group-label", Messages.getInstance().getString("ReportPlugin.SystemParameters"));
        destinationParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", parameterName);
        destinationParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", "textbox");
        destinationParameter.setDeprecated(deprecated);
        return destinationParameter;
    }

    private PlainParameter createGenericBooleanSystemParameter(String parameterName, boolean deprecated, boolean preferredParameter) {
        return this.createGenericSystemParameter(parameterName, deprecated, preferredParameter, Boolean.class);
    }

    private PlainParameter createGenericIntSystemParameter(String parameterName, boolean deprecated, boolean preferredParameter) {
        return this.createGenericSystemParameter(parameterName, deprecated, preferredParameter, Integer.class);
    }

    private StaticListParameter createContentLinkingParameter() {
        StaticListParameter parameter = new StaticListParameter(SYS_PARAM_CONTENT_LINK, true, false, String[].class);
        parameter.setMandatory(false);
        parameter.setHidden(true);
        parameter.setRole(GROUP_SYSTEM);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "preferred", "false");
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group", GROUP_SYSTEM);
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group-label", Messages.getInstance().getString("ReportPlugin.SystemParameters"));
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", Messages.getInstance().getString("ReportPlugin.ContentLinking"));
        parameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", "list");
        return parameter;
    }

    private Object lookupDestination() {
        return this.inputs.get(SYS_PARAM_DESTINATION);
    }

    private StaticListParameter createOutputParameter() {
        StaticListParameter listParameter = new StaticListParameter(SYS_PARAM_OUTPUT_TARGET, false, true, String.class);
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "preferred", String.valueOf(true));
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group", GROUP_PARAMETERS);
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group-label", Messages.getInstance().getString("ReportPlugin.ReportParameters"));
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", Messages.getInstance().getString("ReportPlugin.OutputType"));
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", "dropdown");
        listParameter.setRole(GROUP_SYSTEM);
        ReportOutputHandlerFactory handlerFactory = (ReportOutputHandlerFactory)PentahoSystem.get(ReportOutputHandlerFactory.class);
        if (handlerFactory == null) {
            handlerFactory = new FastExportReportOutputHandlerFactory();
        }
        for (Map.Entry<String, String> entry : handlerFactory.getSupportedOutputTypes()) {
            listParameter.addValues((Object)entry.getKey(), (Object)entry.getValue());
        }
        return listParameter;
    }

    private ParameterDefinitionEntry createRenderModeSystemParameter() {
        StaticListParameter listParameter = new StaticListParameter(SYS_PARAM_RENDER_MODE, false, true, String.class);
        listParameter.setHidden(true);
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "preferred", String.valueOf(false));
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group", GROUP_SYSTEM);
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-group-label", Messages.getInstance().getString("ReportPlugin.SystemParameters"));
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "label", SYS_PARAM_RENDER_MODE);
        listParameter.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", "dropdown");
        listParameter.setRole(GROUP_SYSTEM);
        listParameter.addValues((Object)"XML", (Object)"XML");
        listParameter.addValues((Object)"REPORT", (Object)"REPORT");
        listParameter.addValues((Object)"DOWNLOAD", (Object)"DOWNLOAD");
        listParameter.addValues((Object)"PARAMETER", (Object)"PARAMETER");
        return listParameter;
    }

    private Boolean requestFlag(String parameter, MasterReport report, String attributeNamespace, String attributeName, String configurationKey) {
        if (parameter != null) {
            IParameterProvider parameters = this.getRequestParameters();
            String parameterValue = parameters.getStringParameter(parameter, "");
            if ("true".equals(parameterValue)) {
                return Boolean.TRUE;
            }
            if ("false".equals(parameterValue)) {
                return Boolean.FALSE;
            }
        }
        if (attributeNamespace != null && attributeName != null) {
            Object attr = report.getAttribute(attributeNamespace, attributeName);
            if (Boolean.TRUE.equals(attr) || "true".equals(attr)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.equals(attr) || "false".equals(attr)) {
                return Boolean.FALSE;
            }
        }
        if (configurationKey != null) {
            String configProperty = report.getConfiguration().getConfigProperty(configurationKey);
            if ("true".equals(configProperty)) {
                return Boolean.TRUE;
            }
            if ("false".equals(configProperty)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private String requestConfiguration(String parameter, MasterReport report, String attributeNamespace, String attributeName, String configurationKey) {
        String configProperty;
        Object attr;
        IParameterProvider parameters;
        String parameterValue;
        if (parameter != null && !StringUtils.isEmpty((String)(parameterValue = (parameters = this.getRequestParameters()).getStringParameter(parameter, "")))) {
            return parameterValue;
        }
        if (attributeNamespace != null && attributeName != null && (attr = report.getAttribute(attributeNamespace, attributeName)) != null && !StringUtils.isEmpty((String)String.valueOf(attr))) {
            return String.valueOf(attr);
        }
        if (configurationKey != null && !StringUtils.isEmpty((String)(configProperty = report.getConfiguration().getConfigProperty(configurationKey)))) {
            return configProperty;
        }
        return null;
    }

    private static class OutputParameterCollector {
        private OutputParameterCollector() {
        }

        public String[] collectParameter(MasterReport reportDefinition) {
            LinkedHashSet<String> parameter = new LinkedHashSet<String>();
            this.inspectElement((ReportElement)reportDefinition, parameter);
            this.traverseSection((Section)reportDefinition, parameter);
            return parameter.toArray(new String[parameter.size()]);
        }

        private void traverseSection(Section section, LinkedHashSet<String> parameter) {
            int count = section.getElementCount();
            for (int i = 0; i < count; ++i) {
                org.pentaho.reporting.engine.classic.core.Element element = section.getElement(i);
                this.inspectElement((ReportElement)element, parameter);
                if (!(element instanceof Section)) continue;
                this.traverseSection((Section)element, parameter);
            }
        }

        private void inspectElement(ReportElement element, LinkedHashSet<String> parameter) {
            try {
                String[] expressionStrings;
                Expression expression = element.getStyleExpression(ElementStyleKeys.HREF_TARGET);
                if (expression instanceof FormulaExpression) {
                    FormulaExpression fe = (FormulaExpression)expression;
                    expressionStrings = new String[]{fe.getFormulaExpression()};
                } else {
                    expression = element.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
                    if (expression instanceof ChartExpression) {
                        ChartExpression ce = (ChartExpression)expression;
                        expressionStrings = ce.getHyperlinkFormulas();
                    } else {
                        return;
                    }
                }
                if (null == expressionStrings && expressionStrings.length < 1) {
                    return;
                }
                for (String expressionText : expressionStrings) {
                    DrillDownProfile profile;
                    String config;
                    FormulaParser formulaParser;
                    LValue value;
                    if (StringUtils.isEmpty((String)expressionText)) continue;
                    if (expressionText.startsWith("=")) {
                        expressionText = expressionText.substring(1);
                    }
                    if (!expressionText.startsWith("DRILLDOWN") || !((value = (formulaParser = new FormulaParser()).parse(expressionText)) instanceof FormulaFunction)) continue;
                    DefaultFormulaContext context = new DefaultFormulaContext();
                    value.initialize((FormulaContext)context);
                    FormulaFunction fn = (FormulaFunction)value;
                    LValue[] params = fn.getChildValues();
                    if (params.length != 3 || (config = this.extractText(params[0])) == null || (profile = DrillDownProfileMetaData.getInstance().getDrillDownProfile(config)) == null || StringUtils.isEmpty((String)profile.getAttribute("group")) || !profile.getAttribute("group").startsWith("pentaho") || !(params[2] instanceof DataTable)) continue;
                    DataTable dataTable = (DataTable)params[2];
                    int rowCount = dataTable.getRowCount();
                    int colCount = dataTable.getColumnCount();
                    if (colCount != 2) continue;
                    for (int i = 0; i < rowCount; ++i) {
                        LValue valueAt = dataTable.getValueAt(i, 0);
                        String name = this.extractText(valueAt);
                        if (name == null) continue;
                        parameter.add(name);
                    }
                }
            }
            catch (Exception e) {
                CommonUtil.checkStyleIgnore();
            }
        }

        private String extractText(LValue value) {
            if (value == null) {
                return null;
            }
            if (value.isConstant() && value instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)value;
                Object o = staticValue.getValue();
                if (o == null) {
                    return null;
                }
                return String.valueOf(o);
            }
            return null;
        }
    }
}

