/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class ParameterDependencyGraph {
    private static final String SYS_IGNORE_PARAM = "::org.pentaho.reporting";
    private boolean noDependencyInformationAvailable;
    private LinkedHashMap<String, Set<String>> dependencyGraph = new LinkedHashMap();
    private Set<String> allParameterNames;

    public ParameterDependencyGraph(MasterReport report, Map<String, ParameterDefinitionEntry> reportParameter, ParameterContext parameterContext, Map<String, Object> computedParameterValues) {
        this.allParameterNames = new HashSet<String>(reportParameter.keySet());
        this.noDependencyInformationAvailable = this.processDependentParameters(report, reportParameter, parameterContext, (DataRow)new StaticDataRow(computedParameterValues));
    }

    ParameterDependencyGraph(boolean noDeps, String ... allParameterNames) {
        this.allParameterNames = new HashSet<String>(Arrays.asList(allParameterNames));
        this.noDependencyInformationAvailable = noDeps;
    }

    public void setNoDependencyInformationAvailable(boolean noDependencyInformationAvailable) {
        this.noDependencyInformationAvailable = noDependencyInformationAvailable;
    }

    public boolean getNoDependencyInformationAvailable() {
        return this.noDependencyInformationAvailable;
    }

    public LinkedHashMap<String, Set<String>> getDependencyGraph() {
        return this.dependencyGraph;
    }

    public void setDependencyGraph(LinkedHashMap<String, Set<String>> arg) {
        this.dependencyGraph = arg;
    }

    public Set<String> getAllParameterNames() {
        return this.allParameterNames;
    }

    public void setAllParameterNames(Set<String> allParameterNames) {
        this.allParameterNames = allParameterNames;
    }

    public Set<String> getDependentParameterFor(String parameterName) {
        if (this.noDependencyInformationAvailable) {
            return Collections.emptySet();
        }
        Set strings = this.dependencyGraph.getOrDefault(parameterName, Collections.emptySet());
        return Collections.unmodifiableSet(strings);
    }

    public Set<String> getAllDependencies(String ... parameterNames) {
        return this.getAllDependencies(Arrays.asList(parameterNames));
    }

    public Set<String> getAllDependencies(Iterable<String> parameterNames) {
        if (this.noDependencyInformationAvailable) {
            return Collections.unmodifiableSet(this.allParameterNames);
        }
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String parameterName : parameterNames) {
            retval.addAll(this.getAllDependencies(parameterName, visited));
        }
        return Collections.unmodifiableSet(retval);
    }

    public Set<String> getKnownParameter() {
        return Collections.unmodifiableSet(this.dependencyGraph.keySet());
    }

    private Set<String> getAllDependencies(String parameterName, Set<String> visited) {
        Set<String> p = this.getDependentParameterFor(parameterName);
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        retval.addAll(p);
        for (String d : p) {
            if (visited.contains(d)) continue;
            visited.add(d);
            retval.addAll(this.getAllDependencies(d, visited));
        }
        return retval;
    }

    void addDependency(String parameter, String downstream) {
        Set deps = this.dependencyGraph.computeIfAbsent(parameter, k -> new LinkedHashSet());
        deps.add(downstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processDependentParameters(MasterReport report, Map<String, ParameterDefinitionEntry> reportParameter, ParameterContext parameterContext, DataRow parameterValues) {
        try {
            DesignTimeDataFactoryContext factoryContext = new DesignTimeDataFactoryContext(report);
            CompoundDataFactory cdf = CompoundDataFactory.normalize((DataFactory)report.getDataFactory());
            derive.initialize((DataFactoryContext)factoryContext);
            try (CompoundDataFactory derive = (CompoundDataFactory)cdf.derive();){
                Iterator<ParameterDefinitionEntry> iterator = reportParameter.values().iterator();
                while (iterator.hasNext()) {
                    ParameterDefinitionEntry entry = iterator.next();
                    List<String> dependentParameter = ParameterDependencyGraph.computeNormalLineage(parameterContext, entry);
                    List<String> queryDependencies = this.computeListParameterLineage(derive, entry, parameterValues);
                    if (queryDependencies == null) {
                        boolean bl = true;
                        return bl;
                    }
                    dependentParameter.forEach(p -> this.addDependency((String)p, entry.getName()));
                    queryDependencies.forEach(p -> this.addDependency((String)p, entry.getName()));
                }
                return false;
            }
        }
        catch (ReportDataFactoryException re) {
            DebugLog.log((Object)"Failed to compute dependency information", (Throwable)re);
            return true;
        }
    }

    private List<String> computeListParameterLineage(CompoundDataFactory cdf, ParameterDefinitionEntry entry, DataRow computedParameterValues) {
        if (!(entry instanceof DefaultListParameter)) {
            return Collections.emptyList();
        }
        DefaultListParameter listParameter = (DefaultListParameter)entry;
        String queryName = listParameter.getQueryName();
        if (queryName == null) {
            return Collections.emptyList();
        }
        DataFactory dataFactoryForQuery = cdf.getDataFactoryForQuery(queryName);
        if (dataFactoryForQuery == null) {
            return Collections.emptyList();
        }
        String[] fields = dataFactoryForQuery.getMetaData().getReferencedFields(dataFactoryForQuery, queryName, computedParameterValues);
        if (fields != null) {
            return Arrays.stream(fields).filter(field -> !field.startsWith(SYS_IGNORE_PARAM)).collect(Collectors.toList());
        }
        return null;
    }

    public boolean isNoDependencyInformationAvailable() {
        return this.noDependencyInformationAvailable;
    }

    private static String extractFormula(ParameterContext parameterContext, ParameterDefinitionEntry pe, String attr) {
        return pe.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", attr, parameterContext);
    }

    static List<String> computeNormalLineage(ParameterContext parameterContext, ParameterDefinitionEntry pe) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(ParameterDependencyGraph.analyzeFormula(ParameterDependencyGraph.extractFormula(parameterContext, pe, "default-value-formula")));
        retval.addAll(ParameterDependencyGraph.analyzeFormula(ParameterDependencyGraph.extractFormula(parameterContext, pe, "post-processor-formula")));
        retval.addAll(ParameterDependencyGraph.analyzeFormula(ParameterDependencyGraph.extractFormula(parameterContext, pe, "display-value-formula")));
        return retval;
    }

    private static List<String> analyzeFormula(String formula) {
        if (formula == null) {
            return Collections.emptyList();
        }
        FormulaExpression fe = new FormulaExpression();
        fe.setFormula(formula);
        ExpressionMetaData md = ExpressionRegistry.getInstance().getExpressionMetaData(fe.getClass().getName());
        ExpressionPropertyMetaData pd = md.getPropertyDescription("formula");
        return Arrays.asList(pd.getReferencedFields((Expression)fe, (Object)fe.getFormula()));
    }
}

