/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.platform.plugin.ReportCreator;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;
import org.pentaho.reporting.platform.plugin.async.IJobIdGenerator;
import org.pentaho.reporting.platform.plugin.async.IPentahoAsyncExecutor;
import org.pentaho.reporting.platform.plugin.async.ISchedulingDirectoryStrategy;
import org.pentaho.reporting.platform.plugin.staging.IFixedSizeStreamingContent;

@Path(value="/reporting/api/jobs")
public class JobManager {
    private static final Log logger = LogFactory.getLog(JobManager.class);
    private static final String ASYNC_DISABLED = "JobManager initialization: async mode marked as disabled.";
    private static final String ERROR_GENERATING_REPORT = "Error generating report";
    private static final String UNABLE_TO_SERIALIZE_TO_JSON = "Unable to serialize to json : ";
    private static final String UNCKNOWN_MEDIA_TYPE = "Can't determine JAX-RS media type for: ";
    private final Config config;

    public JobManager() {
        this(true, 500L, 1500L, false);
    }

    public JobManager(boolean isSupportAsync, long pollingIntervalMilliseconds, long dialogThresholdMillisecond) {
        this(isSupportAsync, pollingIntervalMilliseconds, dialogThresholdMillisecond, false);
    }

    public JobManager(boolean isSupportAsync, long pollingIntervalMilliseconds, long dialogThresholdMillisecond, boolean promptForLocation) {
        if (!isSupportAsync) {
            logger.info((Object)ASYNC_DISABLED);
        }
        this.config = new Config(isSupportAsync, pollingIntervalMilliseconds, dialogThresholdMillisecond, promptForLocation);
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        return this.getJson(this.config);
    }

    @GET
    @Path(value="{job_id}/content")
    public Response getPDFContent(@PathParam(value="job_id") String job_id) throws IOException {
        logger.debug((Object)"Chrome pdf viewer workaround. See BACKLOG-7598 for details");
        return this.getContent(job_id);
    }

    @POST
    @Path(value="{job_id}/content")
    public Response getContent(@PathParam(value="job_id") String jobId) throws IOException {
        try {
            MediaType mediaType;
            IFixedSizeStreamingContent input;
            ExecutionContext context = this.getContext(jobId);
            Future future = context.getFuture();
            IAsyncReportState state = context.getReportState();
            if (!AsyncExecutionStatus.FINISHED.equals((Object)state.getStatus())) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            try {
                input = (IFixedSizeStreamingContent)future.get();
            }
            catch (Exception e) {
                logger.error((Object)ERROR_GENERATING_REPORT, (Throwable)e);
                return Response.serverError().build();
            }
            StreamingOutputWrapper stream = new StreamingOutputWrapper(input.getStream());
            try {
                mediaType = MediaType.valueOf((String)state.getMimeType());
            }
            catch (Exception e) {
                logger.warn((Object)(UNCKNOWN_MEDIA_TYPE + state.getMimeType()), (Throwable)e);
                mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            Response.ResponseBuilder response = Response.ok((Object)stream, (MediaType)mediaType);
            response = JobManager.noCache(response);
            response = JobManager.calculateContentDisposition(response, state);
            return response.build();
        }
        catch (ContextFailedException | FutureNotFoundException e) {
            return this.get404();
        }
    }

    @GET
    @Path(value="{job_id}/status")
    @Produces(value={"application/json"})
    public Response getStatus(@PathParam(value="job_id") String jobId) {
        try {
            ExecutionContext context = this.getContext(jobId);
            IAsyncReportState responseJson = context.getReportState();
            return this.getJson(responseJson);
        }
        catch (ContextFailedException e) {
            return this.get404();
        }
    }

    private Response getJson(Object responseJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return Response.ok((Object)mapper.writeValueAsString(responseJson)).build();
        }
        catch (Exception e) {
            logger.error((Object)(UNABLE_TO_SERIALIZE_TO_JSON + responseJson.toString()));
            return Response.serverError().build();
        }
    }

    protected IPentahoAsyncExecutor getExecutor() {
        return (IPentahoAsyncExecutor)PentahoSystem.get(IPentahoAsyncExecutor.class);
    }

    @GET
    @Path(value="{job_id}/cancel")
    public Response cancel(@PathParam(value="job_id") String jobId) {
        try {
            ExecutionContext context = this.getContext(jobId);
            Future future = context.getFuture();
            IAsyncReportState state = context.getReportState();
            logger.debug((Object)("Cancellation of report: " + state.getPath() + ", requested by : " + context.getSession()));
            future.cancel(true);
            return Response.ok().build();
        }
        catch (ContextFailedException e) {
            return this.get404();
        }
        catch (FutureNotFoundException e) {
            return Response.ok().build();
        }
    }

    @GET
    @Path(value="{job_id}/requestPage/{page}")
    @Produces(value={"text/plain"})
    public Response requestPage(@PathParam(value="job_id") String jobId, @PathParam(value="page") int page) {
        try {
            ExecutionContext context = this.getContext(jobId);
            context.requestPage(page);
            return Response.ok((Object)String.valueOf(page)).build();
        }
        catch (ContextFailedException e) {
            return this.get404();
        }
    }

    @GET
    @Path(value="{job_id}/schedule")
    @Produces(value={"text/plain"})
    public Response schedule(@PathParam(value="job_id") String jobId, @DefaultValue(value="true") @QueryParam(value="confirm") boolean confirm) {
        try {
            ExecutionContext context = this.getContext(jobId);
            if (confirm) {
                UUID recalculate;
                if (context.needRecalculation(Boolean.FALSE) && null != (recalculate = context.recalculate())) {
                    context = this.getContext(recalculate.toString());
                }
                context.schedule();
            } else {
                context.preSchedule();
            }
            return Response.ok().build();
        }
        catch (ContextFailedException e) {
            return this.get404();
        }
    }

    @POST
    @Path(value="{job_id}/schedule")
    @Produces(value={"application/json"})
    public Response confirmSchedule(@PathParam(value="job_id") String jobId, @DefaultValue(value="true") @QueryParam(value="confirm") boolean confirm, @DefaultValue(value="false") @QueryParam(value="recalculateFinished") boolean recalculateFinished, @QueryParam(value="folderId") String folderId, @QueryParam(value="newName") String newName) {
        try {
            if (StringUtil.isEmpty((String)folderId) || StringUtil.isEmpty((String)newName)) {
                return this.get404();
            }
            ExecutionContext context = this.getContext(jobId);
            if (confirm) {
                UUID recalculate;
                if (context.needRecalculation(recalculateFinished) && null != (recalculate = context.recalculate())) {
                    context = this.getContext(recalculate.toString());
                }
                context.schedule();
            }
            context.updateSchedulingLocation(folderId, newName);
            return this.getJson(Collections.singletonMap("uuid", context.jobId));
        }
        catch (ContextFailedException e) {
            return this.get404();
        }
    }

    public ExecutionContext getContext(String jobId) throws ContextFailedException {
        ExecutionContext executionContext = new ExecutionContext(jobId);
        executionContext.evaluate();
        return executionContext;
    }

    @POST
    @Path(value="reserveId")
    @Produces(value={"application/json"})
    public Response reserveId() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        IJobIdGenerator iJobIdGenerator = (IJobIdGenerator)PentahoSystem.get(IJobIdGenerator.class);
        if (session != null && iJobIdGenerator != null) {
            UUID reservedId = iJobIdGenerator.generateId(session);
            return this.getJson(Collections.singletonMap("reservedId", reservedId.toString()));
        }
        return this.get404();
    }

    protected final Response get404() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected static Response.ResponseBuilder noCache(Response.ResponseBuilder response) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setPrivate(true);
        cacheControl.setMaxAge(0);
        cacheControl.setMustRevalidate(true);
        response.cacheControl(cacheControl);
        return response;
    }

    protected static Response.ResponseBuilder calculateContentDisposition(Response.ResponseBuilder response, IAsyncReportState state) {
        IOUtils utils = IOUtils.getInstance();
        String targetExt = MimeHelper.getExtension((String)state.getMimeType());
        String fullPath = state.getPath();
        String sourceExt = utils.getFileExtension(fullPath);
        String cleanFileName = utils.stripFileExtension(utils.getFileName(fullPath));
        if (StringUtil.isEmpty((String)cleanFileName)) {
            cleanFileName = "content";
        }
        String disposition = "inline; filename*=UTF-8''" + RepositoryPathEncoder.encode((String)RepositoryPathEncoder.encodeRepositoryPath((String)(cleanFileName + targetExt)));
        response.header("Content-Disposition", (Object)disposition);
        response.header("Content-Description", (Object)(cleanFileName + sourceExt));
        return response;
    }

    private String getLocation() {
        ISchedulingDirectoryStrategy directoryStrategy = (ISchedulingDirectoryStrategy)PentahoSystem.get(ISchedulingDirectoryStrategy.class);
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        if (directoryStrategy != null && repository != null) {
            RepositoryFile outputFolder = directoryStrategy.getSchedulingDir(repository);
            return outputFolder.getPath();
        }
        return "/";
    }

    private static class FutureNotFoundException
    extends Exception {
        public FutureNotFoundException(String message) {
            super(message);
        }
    }

    public static class ContextFailedException
    extends Exception {
        public ContextFailedException(String message) {
            super(message);
        }

        ContextFailedException(Throwable cause) {
            super(cause);
        }
    }

    public class ExecutionContext {
        private IPentahoSession session;
        private final String jobId;
        private UUID uuid = null;

        private ExecutionContext(String jobId) {
            this.jobId = jobId;
        }

        private void evaluate() throws ContextFailedException {
            try {
                this.session = PentahoSessionHolder.getSession();
                this.uuid = UUID.fromString(this.jobId);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new ContextFailedException(e);
            }
        }

        public IPentahoSession getSession() {
            return this.session;
        }

        private IPentahoAsyncExecutor getReportExecutor() {
            return JobManager.this.getExecutor();
        }

        public Future getFuture() throws FutureNotFoundException {
            Future<IFixedSizeStreamingContent> future = this.getReportExecutor().getFuture(this.uuid, this.session);
            if (future == null) {
                throw new FutureNotFoundException("Can't get future");
            }
            return future;
        }

        public IAsyncReportState getReportState() throws ContextFailedException {
            Object reportState = this.getReportExecutor().getReportState(this.uuid, this.session);
            if (reportState == null) {
                throw new ContextFailedException("Can't get state");
            }
            return reportState;
        }

        public void requestPage(int page) throws ContextFailedException {
            this.getReportState();
            this.getReportExecutor().requestPage(this.uuid, this.session, page);
        }

        public void schedule() throws ContextFailedException {
            IAsyncReportState reportState = this.getReportState();
            if (reportState.getStatus().equals((Object)AsyncExecutionStatus.SCHEDULED)) {
                throw new ContextFailedException("Report is already scheduled.");
            }
            this.getReportExecutor().schedule(this.uuid, this.session);
        }

        public void updateSchedulingLocation(String folderId, String newName) throws ContextFailedException {
            if (!JobManager.this.config.isPromptForLocation()) {
                throw new ContextFailedException("Location update is disabled");
            }
            IAsyncReportState reportState = this.getReportState();
            if (!reportState.getStatus().equals((Object)AsyncExecutionStatus.SCHEDULED)) {
                throw new ContextFailedException("Can't update the location of not scheduled report.");
            }
            this.getReportExecutor().updateSchedulingLocation(this.uuid, this.session, (Serializable)((Object)folderId), newName);
        }

        public void preSchedule() throws ContextFailedException {
            this.getReportState();
            this.getReportExecutor().preSchedule(this.uuid, this.session);
        }

        public UUID recalculate() throws ContextFailedException {
            this.getReportState();
            return this.getReportExecutor().recalculate(this.uuid, this.session);
        }

        public boolean needRecalculation(boolean recalculateFinished) throws ContextFailedException {
            return AsyncExecutionStatus.FINISHED.equals((Object)this.getReportState().getStatus()) && recalculateFinished || this.isRowLimitRecalculationNeeded();
        }

        private boolean isRowLimitRecalculationNeeded() throws ContextFailedException {
            try {
                IAsyncReportState state = this.getReportState();
                String path = state.getPath();
                MasterReport report = ReportCreator.createReportByName(path);
                int queryLimit = report.getQueryLimit();
                if (queryLimit > 0) {
                    return Boolean.TRUE;
                }
                if (state.getIsQueryLimitReached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (IOException | ResourceException e) {
                return Boolean.FALSE;
            }
        }
    }

    @JsonPropertyOrder(alphabetic=true)
    private class Config {
        private final boolean isSupportAsync;
        private final long pollingIntervalMilliseconds;
        private final long dialogThresholdMilliseconds;
        private final boolean promptForLocation;

        private Config(boolean isSupportAsync, long pollingIntervalMilliseconds, long dialogThresholdMilliseconds, boolean promptForLocation) {
            this.isSupportAsync = isSupportAsync;
            this.pollingIntervalMilliseconds = pollingIntervalMilliseconds;
            this.dialogThresholdMilliseconds = dialogThresholdMilliseconds;
            this.promptForLocation = promptForLocation;
        }

        public boolean isSupportAsync() {
            return this.isSupportAsync;
        }

        public long getPollingIntervalMilliseconds() {
            return this.pollingIntervalMilliseconds;
        }

        public long getDialogThresholdMilliseconds() {
            return this.dialogThresholdMilliseconds;
        }

        public boolean isPromptForLocation() {
            return this.promptForLocation;
        }

        public String getDefaultOutputPath() {
            return JobManager.this.getLocation();
        }
    }

    protected static final class StreamingOutputWrapper
    implements StreamingOutput {
        private InputStream input;

        public StreamingOutputWrapper(InputStream readFrom) {
            this.input = readFrom;
        }

        public void write(OutputStream outputStream) throws IOException, WebApplicationException {
            try {
                org.apache.commons.io.IOUtils.copy((InputStream)this.input, (OutputStream)outputStream);
                outputStream.flush();
            }
            finally {
                org.apache.commons.io.IOUtils.closeQuietly((OutputStream)outputStream);
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)this.input);
            }
        }
    }
}

