/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntry;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.JobEntryUtils;
import org.pentaho.big.data.kettle.plugins.sqoop.LoggingProxy;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopConfig;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopUtils;
import org.pentaho.bigdata.api.sqoop.SqoopService;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

public abstract class AbstractSqoopJobEntry<S extends SqoopConfig>
extends AbstractJobEntry<S>
implements Cloneable,
JobEntryInterface {
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private DatabaseMeta usedDbConnection;
    private Appender sqoopToKettleAppender;
    private LoggingProxy stdErrProxy;
    private String[] LOGS_TO_MONITOR = new String[]{"org.apache.sqoop", "org.apache.hadoop", "com.pentaho.big.data.bundles.impl.shim.sqoop.knox"};
    private final Map<String, Level> logLevelCache;

    protected abstract String getToolName();

    protected AbstractSqoopJobEntry(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.logLevelCache = Maps.newHashMap();
    }

    public void loadXML(Node node, List<DatabaseMeta> databaseMetas, List<SlaveServer> slaveServers, Repository repository) throws KettleXMLException {
        super.loadXML(node, databaseMetas, slaveServers, repository);
        this.loadUsedDataBaseConnection(databaseMetas, (SqoopConfig)this.getJobConfig());
        if (!this.loadNamedCluster(this.metaStore)) {
            ((SqoopConfig)this.getJobConfig()).loadClusterConfig(node);
        }
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, id_jobentry, databases, slaveServers);
        this.loadUsedDataBaseConnection(databases, (SqoopConfig)this.getJobConfig());
        if (!this.loadNamedCluster(this.metaStore)) {
            try {
                ((SqoopConfig)this.getJobConfig()).loadClusterConfig(rep, id_jobentry);
            }
            catch (KettleException ke) {
                this.logError(ke.getMessage(), ke);
            }
        }
    }

    public String getXML() {
        return super.getXML() + ((SqoopConfig)this.getJobConfig()).getClusterXML();
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        super.saveRep(rep, id_job);
        ((SqoopConfig)this.getJobConfig()).saveClusterConfig(rep, id_job, this);
    }

    private boolean loadNamedCluster(IMetaStore metaStore) {
        try {
            String clusterName = ((SqoopConfig)this.getJobConfig()).getClusterName();
            NamedCluster namedCluster = null;
            if (!Strings.isNullOrEmpty((String)clusterName) && this.namedClusterService.contains(clusterName, metaStore)) {
                namedCluster = this.namedClusterService.read(clusterName, metaStore);
            }
            if (namedCluster != null) {
                ((SqoopConfig)this.getJobConfig()).setNamedCluster(namedCluster);
                return true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        return false;
    }

    @VisibleForTesting
    void loadUsedDataBaseConnection(List<DatabaseMeta> databases, S config) {
        String database = ((SqoopConfig)config).getDatabase();
        DatabaseMeta databaseMeta = DatabaseMeta.findDatabase(databases, (String)database);
        this.setUsedDbConnection(databaseMeta);
        if (database == null) {
            ((SqoopConfig)config).copyConnectionInfoToAdvanced();
        }
    }

    public void attachLoggingAppenders() {
        this.sqoopToKettleAppender = new KettleLogChannelAppender(this.log);
        try {
            Logger sqoopLogger = JobEntryUtils.findLogger((String)this.LOGS_TO_MONITOR[0]);
            if (sqoopLogger != null) {
                this.stdErrProxy = new LoggingProxy(System.err, sqoopLogger, Level.ERROR);
                System.setErr(this.stdErrProxy);
            }
            JobEntryUtils.attachAppenderTo((Appender)this.sqoopToKettleAppender, (LogLevel)this.getLogLevel(), this.logLevelCache, (String[])this.LOGS_TO_MONITOR);
        }
        catch (Exception ex) {
            this.logMinimal(AbstractSqoopJobEntry.getString("ErrorAttachingLogging", new String[0]));
            this.logDebug(Throwables.getStackTraceAsString((Throwable)ex));
            try {
                JobEntryUtils.removeAppenderFrom((Appender)this.sqoopToKettleAppender, this.logLevelCache, (String[])this.LOGS_TO_MONITOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sqoopToKettleAppender = null;
        }
    }

    public void removeLoggingAppenders() {
        try {
            if (this.sqoopToKettleAppender != null) {
                JobEntryUtils.removeAppenderFrom((Appender)this.sqoopToKettleAppender, this.logLevelCache, (String[])this.LOGS_TO_MONITOR);
                this.sqoopToKettleAppender = null;
            }
            if (this.stdErrProxy != null) {
                System.setErr(this.stdErrProxy.getWrappedStream());
                this.stdErrProxy = null;
            }
        }
        catch (Exception ex) {
            this.logError(AbstractSqoopJobEntry.getString("ErrorDetachingLogging", new String[0]));
            this.logDebug(Throwables.getStackTraceAsString((Throwable)ex));
        }
    }

    public List<String> getValidationWarnings(SqoopConfig config) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (StringUtil.isEmpty((String)config.getConnect())) {
            warnings.add(AbstractSqoopJobEntry.getString("ValidationError.Connect.Message", config.getConnect()));
        }
        try {
            JobEntryUtils.asLong((String)config.getBlockingPollingInterval(), (VariableSpace)this.variables);
        }
        catch (NumberFormatException ex) {
            warnings.add(AbstractSqoopJobEntry.getString("ValidationError.BlockingPollingInterval.Message", config.getBlockingPollingInterval()));
        }
        return warnings;
    }

    protected void handleUncaughtThreadException(Thread t, Throwable e, Result jobResult) {
        this.logError(AbstractSqoopJobEntry.getString("ErrorRunningSqoopTool", new String[0]), e);
        this.removeLoggingAppenders();
        this.setJobResultFailed(jobResult);
    }

    protected Runnable getExecutionRunnable(final Result jobResult) throws KettleException {
        return new Runnable(){

            @Override
            public void run() {
                AbstractSqoopJobEntry.this.executeSqoop(jobResult);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSqoop(Result jobResult) {
        SqoopConfig config = (SqoopConfig)this.getJobConfig();
        Properties properties = new Properties();
        this.attachLoggingAppenders();
        try {
            this.configure(config, properties);
            List<String> args = SqoopUtils.getCommandLineArgs(config, this.getVariables());
            args.add(0, this.getToolName());
            this.loadNamedCluster(this.getMetaStore());
            NamedCluster namedCluster = config.getNamedCluster().clone();
            namedCluster.copyVariablesFrom((VariableSpace)this);
            SqoopService service = (SqoopService)this.namedClusterServiceLocator.getService(namedCluster, SqoopService.class);
            int result = service.runTool(args, properties);
            if (result != 0) {
                this.setJobResultFailed(jobResult);
            }
        }
        catch (Exception ex) {
            this.logError(AbstractSqoopJobEntry.getString("ErrorRunningSqoopTool", new String[0]), ex);
            this.setJobResultFailed(jobResult);
        }
        finally {
            this.removeLoggingAppenders();
        }
    }

    public void configure(S sqoopConfig, Properties properties) throws KettleException {
        this.configureDatabase(sqoopConfig);
    }

    public void configureDatabase(S sqoopConfig) throws KettleException {
        DatabaseMeta databaseMeta = this.getParentJob().getJobMeta().findDatabase(((SqoopConfig)sqoopConfig).getDatabase());
        if (((SqoopConfig)sqoopConfig).getModeAsEnum() == JobEntryMode.QUICK_SETUP && databaseMeta != null) {
            ((SqoopConfig)sqoopConfig).setConnectionInfo(databaseMeta.environmentSubstitute(databaseMeta.getName()), databaseMeta.environmentSubstitute(databaseMeta.getURL()), databaseMeta.environmentSubstitute(databaseMeta.getUsername()), Encr.decryptPasswordOptionallyEncrypted((String)databaseMeta.environmentSubstitute(databaseMeta.getPassword())));
        }
    }

    public boolean isDatabaseSupported(Class<? extends DatabaseInterface> databaseType) {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.usedDbConnection};
    }

    public DatabaseMeta getUsedDbConnection() {
        return this.usedDbConnection;
    }

    public void setUsedDbConnection(DatabaseMeta usedDbConnection) {
        this.usedDbConnection = usedDbConnection;
    }

    @VisibleForTesting
    protected void setLogChannel(LogChannelInterface logChannel) {
        this.log = logChannel;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    private static String getString(String key, String ... parameters) {
        return BaseMessages.getString(AbstractSqoopJobEntry.class, (String)key, (String[])parameters);
    }
}

