/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CQ;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.RPT;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.model.v251.datatype.TM;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class TQ1
extends AbstractSegment {
    public TQ1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - TQ1");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Quantity");
            this.add(RPT.class, false, 0, 540, new Object[]{this.getMessage(), new Integer(335)}, "Repeat Pattern");
            this.add(TM.class, false, 0, 20, new Object[]{this.getMessage(), new Integer(0)}, "Explicit Time");
            this.add(CQ.class, false, 0, 20, new Object[]{this.getMessage(), new Integer(0)}, "Relative Time and Units");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Service Duration");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Start date/time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "End date/time");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(485)}, "Priority");
            this.add(TX.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Condition text");
            this.add(TX.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Text instruction");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage()}, "Conjunction");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Occurrence duration");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(0)}, "Total occurrence's");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating TQ1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDTQ1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getTq11_SetIDTQ1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getQuantity() {
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTq12_Quantity() {
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RPT[] getRepeatPattern() {
        RPT[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new RPT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (RPT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RPT getRepeatPattern(int rep) {
        RPT ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (RPT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RPT getTq13_RepeatPattern(int rep) {
        RPT ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (RPT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RPT insertRepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.insertRepetition(3, rep);
    }

    public RPT insertTq13_RepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.insertRepetition(3, rep);
    }

    public RPT removeRepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.removeRepetition(3, rep);
    }

    public RPT removeTq13_RepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.removeRepetition(3, rep);
    }

    public TM[] getExplicitTime() {
        TM[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new TM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TM)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TM getExplicitTime(int rep) {
        TM ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (TM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TM getTq14_ExplicitTime(int rep) {
        TM ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (TM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TM insertExplicitTime(int rep) throws HL7Exception {
        return (TM)super.insertRepetition(4, rep);
    }

    public TM insertTq14_ExplicitTime(int rep) throws HL7Exception {
        return (TM)super.insertRepetition(4, rep);
    }

    public TM removeExplicitTime(int rep) throws HL7Exception {
        return (TM)super.removeRepetition(4, rep);
    }

    public TM removeTq14_ExplicitTime(int rep) throws HL7Exception {
        return (TM)super.removeRepetition(4, rep);
    }

    public CQ[] getRelativeTimeAndUnits() {
        CQ[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new CQ[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CQ)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getRelativeTimeAndUnits(int rep) {
        CQ ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTq15_RelativeTimeAndUnits(int rep) {
        CQ ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ insertRelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.insertRepetition(5, rep);
    }

    public CQ insertTq15_RelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.insertRepetition(5, rep);
    }

    public CQ removeRelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.removeRepetition(5, rep);
    }

    public CQ removeTq15_RelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.removeRepetition(5, rep);
    }

    public CQ getServiceDuration() {
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTq16_ServiceDuration() {
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getStartDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getTq17_StartDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEndDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getTq18_EndDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getPriority() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPriority(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getTq19_Priority(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE insertPriority(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertTq19_Priority(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removePriority(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeTq19_Priority(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public TX getConditionText() {
        TX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TX getTq110_ConditionText() {
        TX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TX getTextInstruction() {
        TX ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TX getTq111_TextInstruction() {
        TX ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getConjunction() {
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getTq112_Conjunction() {
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getOccurrenceDuration() {
        CQ ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTq113_OccurrenceDuration() {
        CQ ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTotalOccurrenceS() {
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTq114_TotalOccurrenceS() {
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CQ(this.getMessage());
            }
            case 2: {
                return new RPT(this.getMessage());
            }
            case 3: {
                return new TM(this.getMessage());
            }
            case 4: {
                return new CQ(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new TX(this.getMessage());
            }
            case 10: {
                return new TX(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(427));
            }
            case 12: {
                return new CQ(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

