/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundleCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="id", description="The bundle ID or name or name/version", required=true, multiValued=false)
    String id;
    boolean defaultAllBundles = true;
    BundleService bundleService;

    public BundleCommand(boolean defaultAllBundles) {
        this.defaultAllBundles = defaultAllBundles;
    }

    protected Object doExecute() throws Exception {
        return this.doExecute(true);
    }

    protected Object doExecute(boolean force) throws Exception {
        Bundle bundle = this.bundleService.getBundle(this.id, this.defaultAllBundles);
        if (bundle != null) {
            if (force || !ShellUtil.isASystemBundle((BundleContext)this.bundleContext, (Bundle)bundle)) {
                this.doExecute(bundle);
            } else {
                System.err.println("Access to system bundle " + this.id + " is discouraged. You may override with -f");
            }
        } else {
            System.err.println("Bundle " + this.id + " is not found");
        }
        return null;
    }

    protected abstract void doExecute(Bundle var1) throws Exception;

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }
}

