/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.update.UpdateMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class UpdateDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = UpdateMeta.class;
    private CCombo wConnection;
    private Label wlKey;
    private TableView wKey;
    private FormData fdlKey;
    private FormData fdKey;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private FormData fdbSchema;
    private Button wbSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlCommit;
    private TextVar wCommit;
    private FormData fdlCommit;
    private FormData fdCommit;
    private Label wlBatch;
    private Button wBatch;
    private FormData fdlBatch;
    private FormData fdBatch;
    private Label wlErrorIgnored;
    private Button wErrorIgnored;
    private FormData fdlErrorIgnored;
    private FormData fdErrorIgnored;
    private Label wlIgnoreFlagField;
    private Text wIgnoreFlagField;
    private FormData fdlIgnoreFlagField;
    private FormData fdIgnoreFlagField;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private UpdateMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;
    private Label wlSkipLookup;
    private Button wSkipLookup;
    private FormData fdlSkipLookup;
    private FormData fdSkipLookup;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public UpdateDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (UpdateMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdateDialog.this.input.setChanged();
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlCommit = new Label((Composite)this.shell, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"UpdateDialog..Commit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommit);
        this.fdlCommit = new FormData();
        this.fdlCommit.left = new FormAttachment(0, 0);
        this.fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.fdlCommit.right = new FormAttachment(middle, -margin);
        this.wlCommit.setLayoutData((Object)this.fdlCommit);
        this.wCommit = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        this.fdCommit = new FormData();
        this.fdCommit.left = new FormAttachment(middle, 0);
        this.fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData(this.fdCommit);
        this.wlBatch = new Label((Composite)this.shell, 131072);
        this.wlBatch.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Batch.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBatch);
        this.fdlBatch = new FormData();
        this.fdlBatch.left = new FormAttachment(0, 0);
        this.fdlBatch.top = new FormAttachment((Control)this.wCommit, margin);
        this.fdlBatch.right = new FormAttachment(middle, -margin);
        this.wlBatch.setLayoutData((Object)this.fdlBatch);
        this.wBatch = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wBatch);
        this.fdBatch = new FormData();
        this.fdBatch.left = new FormAttachment(middle, 0);
        this.fdBatch.top = new FormAttachment((Control)this.wCommit, margin);
        this.fdBatch.right = new FormAttachment(100, 0);
        this.wBatch.setLayoutData((Object)this.fdBatch);
        this.wBatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                UpdateDialog.this.setFlags();
                UpdateDialog.this.input.setChanged();
            }
        });
        this.wlSkipLookup = new Label((Composite)this.shell, 131072);
        this.wlSkipLookup.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SkipLookup.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSkipLookup);
        this.fdlSkipLookup = new FormData();
        this.fdlSkipLookup.left = new FormAttachment(0, 0);
        this.fdlSkipLookup.top = new FormAttachment((Control)this.wBatch, margin);
        this.fdlSkipLookup.right = new FormAttachment(middle, -margin);
        this.wlSkipLookup.setLayoutData((Object)this.fdlSkipLookup);
        this.wSkipLookup = new Button((Composite)this.shell, 32);
        this.wSkipLookup.setToolTipText(BaseMessages.getString(PKG, (String)"UpdateDialog.SkipLookup.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSkipLookup);
        this.fdSkipLookup = new FormData();
        this.fdSkipLookup.left = new FormAttachment(middle, 0);
        this.fdSkipLookup.top = new FormAttachment((Control)this.wBatch, margin);
        this.fdSkipLookup.right = new FormAttachment(100, 0);
        this.wSkipLookup.setLayoutData((Object)this.fdSkipLookup);
        this.wSkipLookup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setActiveIgnoreLookup();
            }
        });
        this.wlErrorIgnored = new Label((Composite)this.shell, 131072);
        this.wlErrorIgnored.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorIgnored.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrorIgnored);
        this.fdlErrorIgnored = new FormData();
        this.fdlErrorIgnored.left = new FormAttachment(0, 0);
        this.fdlErrorIgnored.top = new FormAttachment((Control)this.wSkipLookup, margin);
        this.fdlErrorIgnored.right = new FormAttachment(middle, -margin);
        this.wlErrorIgnored.setLayoutData((Object)this.fdlErrorIgnored);
        this.wErrorIgnored = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wErrorIgnored);
        this.wErrorIgnored.setToolTipText(BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorIgnored.ToolTip", (String[])new String[0]));
        this.fdErrorIgnored = new FormData();
        this.fdErrorIgnored.left = new FormAttachment(middle, 0);
        this.fdErrorIgnored.top = new FormAttachment((Control)this.wSkipLookup, margin);
        this.wErrorIgnored.setLayoutData((Object)this.fdErrorIgnored);
        this.wErrorIgnored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setFlags();
            }
        });
        this.wlIgnoreFlagField = new Label((Composite)this.shell, 16384);
        this.wlIgnoreFlagField.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.FlagField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIgnoreFlagField);
        this.fdlIgnoreFlagField = new FormData();
        this.fdlIgnoreFlagField.left = new FormAttachment((Control)this.wErrorIgnored, margin);
        this.fdlIgnoreFlagField.top = new FormAttachment((Control)this.wSkipLookup, margin);
        this.wlIgnoreFlagField.setLayoutData((Object)this.fdlIgnoreFlagField);
        this.wIgnoreFlagField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wIgnoreFlagField);
        this.wIgnoreFlagField.addModifyListener(lsMod);
        this.fdIgnoreFlagField = new FormData();
        this.fdIgnoreFlagField.left = new FormAttachment((Control)this.wlIgnoreFlagField, margin);
        this.fdIgnoreFlagField.top = new FormAttachment((Control)this.wSkipLookup, margin);
        this.fdIgnoreFlagField.right = new FormAttachment(100, 0);
        this.wIgnoreFlagField.setLayoutData((Object)this.fdIgnoreFlagField);
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Key.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        this.fdlKey = new FormData();
        this.fdlKey.left = new FormAttachment(0, 0);
        this.fdlKey.top = new FormAttachment((Control)this.wIgnoreFlagField, margin);
        this.wlKey.setLayoutData((Object)this.fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getKeyStream() != null ? this.input.getKeyStream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "= ~NULL", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)this.wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.fdKey = new FormData();
        this.fdKey.left = new FormAttachment(0, 0);
        this.fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        this.fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdKey.bottom = new FormAttachment((Control)this.wlKey, 190);
        this.wKey.setLayoutData(this.fdKey);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wSQL}, margin, null);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Return.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 2;
        int UpInsRows = this.input.getUpdateLookup() != null ? this.input.getUpdateLookup().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetAndUpdateFields", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wGetLU, -margin);
        this.fdReturn.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = UpdateDialog.this.transMeta.findStep(UpdateDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = UpdateDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            UpdateDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        UpdateDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        UpdateDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                UpdateDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                UpdateDialog.this.get();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                UpdateDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                UpdateDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                UpdateDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wCommit.addSelectionListener(this.lsDef);
        this.wIgnoreFlagField.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                UpdateDialog.this.cancel();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.getSchemaNames();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setActiveIgnoreLookup();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setActiveIgnoreLookup() {
        if (this.wSkipLookup.getSelection()) {
            this.wErrorIgnored.setSelection(false);
            this.wIgnoreFlagField.setText("");
        }
        this.wErrorIgnored.setEnabled(!this.wSkipLookup.getSelection());
        this.wlErrorIgnored.setEnabled(!this.wSkipLookup.getSelection());
        this.wlIgnoreFlagField.setEnabled(!this.wSkipLookup.getSelection() && this.wErrorIgnored.getSelection());
        this.wIgnoreFlagField.setEnabled(!this.wSkipLookup.getSelection() && this.wErrorIgnored.getSelection());
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[2].setComboValues(fieldNames);
        this.ciKey[3].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        this.wlIgnoreFlagField.setEnabled(this.wErrorIgnored.getSelection());
        this.wIgnoreFlagField.setEnabled(this.wErrorIgnored.getSelection());
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        boolean hasErrorHandling = this.transMeta.findStep(this.stepname).isDoingErrorHandling();
        boolean enableBatch = this.wBatch.getSelection() && !this.transMeta.isUsingUniqueConnections();
        enableBatch = enableBatch && (databaseMeta == null || !databaseMeta.supportsErrorHandlingOnBatchUpdates() || !hasErrorHandling);
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!(UpdateDialog.this.wTable.isDisposed() || UpdateDialog.this.wConnection.isDisposed() || UpdateDialog.this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = UpdateDialog.this.wTable.getText();
                    String connectionName = UpdateDialog.this.wConnection.getText();
                    String schemaName = UpdateDialog.this.wSchema.getText();
                    for (ColumnInfo colInfo : UpdateDialog.this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (ci = UpdateDialog.this.transMeta.findDatabase(connectionName)) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            RowMetaInterface r = db.getTableFieldsMeta(UpdateDialog.this.transMeta.environmentSubstitute(schemaName), UpdateDialog.this.transMeta.environmentSubstitute(tableName));
                            if (null != r && null != (fieldNames = r.getFieldNames())) {
                                for (ColumnInfo colInfo : UpdateDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : UpdateDialog.this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                        finally {
                            try {
                                if (db != null) {
                                    db.disconnect();
                                }
                            }
                            catch (Exception ignored) {
                                db = null;
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSizeVar());
        this.wBatch.setSelection(this.input.useBatchUpdate());
        this.wSkipLookup.setSelection(this.input.isSkipLookup());
        this.wErrorIgnored.setSelection(this.input.isErrorIgnored());
        if (this.input.getIgnoreFlagField() != null) {
            this.wIgnoreFlagField.setText(this.input.getIgnoreFlagField());
        }
        if (this.input.getKeyStream() != null) {
            for (i = 0; i < this.input.getKeyStream().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyCondition()[i] != null) {
                    item.setText(2, this.input.getKeyCondition()[i]);
                }
                if (this.input.getKeyStream()[i] != null) {
                    item.setText(3, this.input.getKeyStream()[i]);
                }
                if (this.input.getKeyStream2()[i] == null) continue;
                item.setText(4, this.input.getKeyStream2()[i]);
            }
        }
        if (this.input.getUpdateLookup() != null) {
            for (i = 0; i < this.input.getUpdateLookup().length; ++i) {
                item = this.wReturn.table.getItem(i);
                if (this.input.getUpdateLookup()[i] != null) {
                    item.setText(1, this.input.getUpdateLookup()[i]);
                }
                if (this.input.getUpdateStream()[i] == null) continue;
                item.setText(2, this.input.getUpdateStream()[i]);
            }
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(UpdateMeta inf) {
        TableItem item;
        int i;
        int nrkeys = this.wKey.nrNonEmpty();
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrkeys, nrfields);
        inf.setCommitSize(this.wCommit.getText());
        inf.setUseBatchUpdate(this.wBatch.getSelection());
        inf.setSkipLookup(this.wSkipLookup.getSelection());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.FoundKeys", (String[])new String[]{nrkeys + ""}));
        }
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            inf.getKeyLookup()[i] = item.getText(1);
            inf.getKeyCondition()[i] = item.getText(2);
            inf.getKeyStream()[i] = item.getText(3);
            inf.getKeyStream2()[i] = item.getText(4);
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.FoundFields", (String[])new String[]{nrfields + ""}));
        for (i = 0; i < nrfields; ++i) {
            item = this.wReturn.getNonEmpty(i);
            inf.getUpdateLookup()[i] = item.getText(1);
            inf.getUpdateStream()[i] = item.getText(2);
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setErrorIgnored(this.wErrorIgnored.getSelection());
        inf.setIgnoreFlagField(this.wIgnoreFlagField.getText());
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, "=");
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 1, new int[]{1, 3}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            UpdateMeta info = new UpdateMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepinfo = new StepMeta(BaseMessages.getString(PKG, (String)"UpdateDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepinfo, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"UpdateDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"UpdateDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }
}

