/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import org.eclipse.swt.graphics.Image;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.provider.AutomaticTreeFolderProvider;

public class HopsFolderProvider
extends AutomaticTreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_HOPS = BaseMessages.getString(PKG, (String)"Spoon.STRING_HOPS", (String[])new String[0]);
    private GUIResource guiResource;

    public HopsFolderProvider(GUIResource guiResource) {
        this.guiResource = guiResource;
    }

    public HopsFolderProvider() {
        this(GUIResource.getInstance());
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        TransMeta transMeta = (TransMeta)meta;
        for (int i = 0; i < transMeta.nrTransHops(); ++i) {
            TransHopMeta hopMeta = transMeta.getTransHop(i);
            if (!this.filterMatch(hopMeta.toString(), filter)) continue;
            Image icon = hopMeta.isEnabled() ? this.guiResource.getImageHopTree() : this.guiResource.getImageDisabledHopTree();
            this.createTreeNode(treeNode, hopMeta.toString(), icon);
        }
    }

    @Override
    public String getTitle() {
        return STRING_HOPS;
    }

    @Override
    public Class getType() {
        return TransHopMeta.class;
    }
}

