/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

public class JobSaveProgressDialog {
    private Shell shell;
    private Repository rep;
    private JobMeta jobMeta;
    private String versionComment;

    public JobSaveProgressDialog(Shell shell, Repository rep, JobMeta jobInfo, String versionComment) {
        this.shell = shell;
        this.rep = rep;
        this.jobMeta = jobInfo;
        this.versionComment = versionComment;
    }

    public boolean open() {
        boolean retval = true;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    JobSaveProgressDialog.this.rep.save((RepositoryElementInterface)JobSaveProgressDialog.this.jobMeta, JobSaveProgressDialog.this.versionComment, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, "Error saving job");
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, "Error saving job", "An error occured saving the job!", e);
            retval = false;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, "Error saving job", "An error occured saving the job!", e);
            retval = false;
        }
        return retval;
    }
}

