/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.ui.core.widget.TextVar;

public class SimpleFileSelection
extends SelectionAdapter {
    public static final String DEFAULT_FILTER_EXTENSION = "*";
    public static final String DEFAULT_FILTER_NAME = "All files (*.*)";
    private final Shell shell;
    private final TextVar textVar;
    private final String[] filterExtensions;
    private final String[] filterNames;

    public SimpleFileSelection(Shell shell, TextVar textVar, String[] filterExtensions, String[] filterNames) throws IllegalArgumentException {
        Assert.assertNotNull((Object)shell, (String)"Shell cannot be null");
        Assert.assertNotNull((Object)((Object)textVar), (String)"Text var cannot be null");
        Assert.assertNotNull((Object)filterNames, (String)"Filter names cannot be null");
        Assert.assertNotNull((Object)filterExtensions, (String)"Filter extensions cannot be null");
        this.shell = shell;
        this.textVar = textVar;
        this.filterExtensions = new String[filterExtensions.length];
        System.arraycopy(filterExtensions, 0, this.filterExtensions, 0, filterExtensions.length);
        this.filterNames = new String[filterNames.length];
        System.arraycopy(filterNames, 0, this.filterNames, 0, filterNames.length);
    }

    public SimpleFileSelection(Shell shell, TextVar textVar) throws IllegalArgumentException {
        this(shell, textVar, new String[]{DEFAULT_FILTER_EXTENSION}, new String[]{DEFAULT_FILTER_NAME});
    }

    public SimpleFileSelection(Shell shell, TextVar textVar, String ... filterNames) throws IllegalArgumentException {
        this(shell, textVar, new String[]{DEFAULT_FILTER_EXTENSION}, filterNames);
    }

    public void widgetSelected(SelectionEvent event) {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterExtensions(this.filterExtensions);
        dialog.setFilterNames(this.filterNames);
        if (this.textVar.getText() != null) {
            dialog.setFileName(this.textVar.getText());
        }
        if (dialog.open() != null) {
            String filename = FilenameUtils.concat((String)dialog.getFilterPath(), (String)dialog.getFileName());
            this.textVar.setText(filename);
        }
    }
}

