/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.metadata.service;

import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.datatable.DataTable;
import org.pentaho.metadata.model.thin.MetadataModelsService;
import org.pentaho.metadata.model.thin.Model;
import org.pentaho.metadata.model.thin.ModelInfo;
import org.pentaho.metadata.model.thin.Query;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;

public class MetadataModelsContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = -3934988366302705814L;
    private Log logger = LogFactory.getLog(MetadataModelsContentGenerator.class);
    public static final String LIST_MODELS_ACTION = "listmodels";
    public static final String GET_MODEL_ACTION = "getmodel";
    public static final String QUERY_ACTION = "query";

    public void createContent(OutputStream output) throws Exception {
        IParameterProvider params = (IParameterProvider)this.parameterProviders.get("request");
        String action = params.getStringParameter("action", null);
        if (LIST_MODELS_ACTION.equals(action)) {
            String providerId = params.getStringParameter("providerid", null);
            String groupId = params.getStringParameter("groupid", null);
            String match = params.getStringParameter("match", null);
            MetadataModelsService svc = new MetadataModelsService();
            ModelInfo[] infos = svc.getModelList(providerId, groupId, match);
            this.writeJson(infos, output);
        } else if (GET_MODEL_ACTION.equals(action)) {
            String id = params.getStringParameter("id", null);
            MetadataModelsService svc = new MetadataModelsService();
            Model model = svc.getModel(id);
            this.writeJson(model, output);
        } else if (QUERY_ACTION.equals(action)) {
            String queryStr = params.getStringParameter(QUERY_ACTION, null);
            int rowLimit = (int)params.getLongParameter("rowlimit", -1L);
            JSONDeserializer de = new JSONDeserializer();
            Query query = (Query)de.deserialize(queryStr);
            MetadataModelsService svc = new MetadataModelsService();
            DataTable table = svc.executeQuery(query, rowLimit);
            this.writeJson(table, output);
        }
    }

    protected void writeJson(Object object, OutputStream output) {
        try {
            JSONSerializer json = new JSONSerializer();
            String jsonStr = json.deepSerialize(object);
            output.write(jsonStr.getBytes());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not write JSON to output stream", (Throwable)e);
        }
    }

    public String getMimeType() {
        return "application/json";
    }

    public Log getLogger() {
        return this.logger;
    }
}

