/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.model.IEEUser;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.UIEEObjectRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryUser;

public class UIEERepositoryUser
extends UIRepositoryUser
implements IUIEEUser,
Serializable {
    private static final long serialVersionUID = -4653578043082025692L;
    private IEEUser eeUser;

    public UIEERepositoryUser() {
    }

    public UIEERepositoryUser(IUser user) {
        super(user);
        if (user instanceof IEEUser) {
            this.eeUser = (IEEUser)user;
        }
    }

    @Override
    public boolean addRole(IUIRole role) {
        return this.eeUser.addRole(role.getRole());
    }

    @Override
    public boolean removeRole(IUIRole role) {
        return this.removeRole(role.getRole().getName());
    }

    @Override
    public void clearRoles() {
        this.eeUser.clearRoles();
    }

    @Override
    public void setRoles(Set<IUIRole> roles) {
        HashSet<IRole> roleSet = new HashSet<IRole>();
        for (IUIRole role : roles) {
            roleSet.add(role.getRole());
        }
        this.eeUser.setRoles(roleSet);
    }

    @Override
    public Set<IUIRole> getRoles() {
        HashSet<IUIRole> rroles = new HashSet<IUIRole>();
        for (IRole role : this.eeUser.getRoles()) {
            try {
                rroles.add(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(role));
            }
            catch (UIObjectCreationException uIObjectCreationException) {}
        }
        return rroles;
    }

    private boolean removeRole(String roleName) {
        IRole roleInfo = null;
        for (IRole role : this.eeUser.getRoles()) {
            if (!role.getName().equals(roleName)) continue;
            roleInfo = role;
            break;
        }
        if (roleInfo != null) {
            return this.eeUser.removeRole(roleInfo);
        }
        return false;
    }

    public String toString() {
        return this.eeUser.getLogin();
    }
}

