/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcls;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.repositoryexplorer.AccessDeniedException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;

public class UIEERepositoryDirectory
extends UIRepositoryDirectory
implements IAclObject,
Serializable {
    private static final long serialVersionUID = -6273975748634580673L;
    private IAclService aclService;
    private Map<RepositoryFilePermission, Boolean> hasAccess = null;

    public UIEERepositoryDirectory() {
    }

    public UIEERepositoryDirectory(RepositoryDirectoryInterface rd, UIRepositoryDirectory uiParent, Repository rep) {
        super(rd, uiParent, rep);
        this.initializeService(rep);
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls, boolean forceParentInheriting) throws AccessDeniedException {
        try {
            acls.setObjectAcl(this.aclService.getAcl(this.getObjectId(), forceParentInheriting));
        }
        catch (KettleException ke) {
            throw new AccessDeniedException((Throwable)ke);
        }
    }

    @Override
    public void getAcls(UIRepositoryObjectAcls acls) throws AccessDeniedException {
        try {
            acls.setObjectAcl(this.aclService.getAcl(this.getObjectId(), false));
        }
        catch (KettleException ke) {
            throw new AccessDeniedException((Throwable)ke);
        }
    }

    @Override
    public void setAcls(UIRepositoryObjectAcls security) throws AccessDeniedException {
        try {
            this.aclService.setAcl(this.getObjectId(), security.getObjectAcl());
        }
        catch (KettleException e) {
            throw new AccessDeniedException((Throwable)e);
        }
    }

    private void initializeService(Repository rep) {
        try {
            if (!rep.hasService(IAclService.class)) {
                throw new IllegalStateException();
            }
            this.aclService = (IAclService)rep.getService(IAclService.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(boolean deleteHomeDirectories) throws Exception {
        if (this.rep instanceof RepositoryExtended) {
            ((RepositoryExtended)this.rep).deleteRepositoryDirectory((RepositoryDirectoryInterface)this.getDirectory(), deleteHomeDirectories);
        } else {
            this.rep.deleteRepositoryDirectory((RepositoryDirectoryInterface)this.getDirectory());
        }
        if (this.getParent().getChildren().contains((Object)this)) {
            this.getParent().getChildren().remove((Object)this);
        }
        if (this.getParent().getRepositoryObjects().contains((Object)this)) {
            this.getParent().getRepositoryObjects().remove((Object)this);
        }
        this.getParent().refresh();
    }

    public void setName(String name, boolean renameHomeDirectories) throws Exception {
        if (this.getDirectory().getName().equalsIgnoreCase(name)) {
            return;
        }
        if (this.rep instanceof RepositoryExtended) {
            ((RepositoryExtended)this.rep).renameRepositoryDirectory(this.getDirectory().getObjectId(), null, name, renameHomeDirectories);
        } else {
            this.rep.renameRepositoryDirectory(this.getDirectory().getObjectId(), null, name);
        }
        this.obj = this.rep.getObjectInformation(this.getObjectId(), this.getRepositoryElementType());
        this.refresh();
    }

    @Override
    public void clearAcl() {
        this.hasAccess = null;
    }

    @Override
    public boolean hasAccess(RepositoryFilePermission perm) throws KettleException {
        if (this.hasAccess == null) {
            this.hasAccess = new HashMap<RepositoryFilePermission, Boolean>();
        }
        if (this.hasAccess.get(perm) == null) {
            this.hasAccess.put(perm, new Boolean(this.aclService.hasAccess(this.getObjectId(), perm)));
        }
        return this.hasAccess.get(perm);
    }
}

