/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.repository.pur.IRepositoryConfigDialogCallback;
import org.pentaho.di.ui.repository.pur.controller.RepositoryConfigController;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class PurRepositoryDialog
implements RepositoryDialogInterface,
Serializable {
    private static final long serialVersionUID = -4642068735574655692L;
    protected RepositoryMeta repositoryMeta;
    protected RepositoriesMeta repositoriesMeta;
    protected RepositoriesMeta masterRepositoriesMeta;
    protected String masterRepositoryName;
    protected Shell parent;
    protected int style;
    private static final Class<?> PKG = PurRepositoryDialog.class;
    private static Log log = LogFactory.getLog(PurRepositoryDialog.class);
    private RepositoryConfigController repositoryConfigController = new RepositoryConfigController();
    private XulDomContainer container;
    private ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };

    public PurRepositoryDialog(Shell parent, int style, RepositoryMeta repositoryMeta, RepositoriesMeta repositoriesMeta) {
        this.parent = parent;
        this.repositoriesMeta = repositoriesMeta;
        this.repositoryMeta = repositoryMeta;
        this.style = style;
        this.masterRepositoriesMeta = repositoriesMeta.clone();
        this.masterRepositoryName = repositoryMeta.getName();
    }

    public RepositoryMeta open(final RepositoryDialogInterface.MODE mode) {
        try {
            SwtXulLoader swtLoader = new SwtXulLoader();
            swtLoader.setOuterContext((Object)this.parent);
            swtLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            this.container = swtLoader.loadXul("org/pentaho/di/ui/repository/pur/xul/pur-repository-config-dialog.xul", (Object)this.resourceBundle);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(this.container);
            this.parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    PurRepositoryDialog.this.hide();
                }
            });
            this.repositoryConfigController.setMessages(this.resourceBundle);
            this.repositoryConfigController.setRepositoryMeta(this.repositoryMeta);
            this.repositoryConfigController.setCallback(new IRepositoryConfigDialogCallback(){

                @Override
                public void onSuccess(PurRepositoryMeta meta) {
                    if (meta.getName() != null) {
                        if (mode == RepositoryDialogInterface.MODE.ADD) {
                            if (PurRepositoryDialog.this.masterRepositoriesMeta.searchRepository(meta.getName()) == null) {
                                PurRepositoryDialog.this.repositoryMeta = meta;
                                PurRepositoryDialog.this.hide();
                            } else {
                                PurRepositoryDialog.this.displayRepositoryAlreadyExistMessage(meta.getName());
                            }
                        } else if (PurRepositoryDialog.this.masterRepositoryName.equals(meta.getName())) {
                            PurRepositoryDialog.this.repositoryMeta = meta;
                            PurRepositoryDialog.this.hide();
                        } else if (PurRepositoryDialog.this.masterRepositoriesMeta.searchRepository(meta.getName()) == null) {
                            PurRepositoryDialog.this.repositoryMeta = meta;
                            PurRepositoryDialog.this.hide();
                        } else {
                            PurRepositoryDialog.this.displayRepositoryAlreadyExistMessage(meta.getName());
                        }
                    }
                }

                @Override
                public void onError(Throwable t) {
                    SpoonFactory.getInstance().messageBox(t.getLocalizedMessage(), PurRepositoryDialog.this.resourceBundle.getString("RepositoryConfigDialog.InitializationFailed"), false, 2);
                    log.error((Object)PurRepositoryDialog.this.resourceBundle.getString("RepositoryConfigDialog.ErrorStartingXulApplication"), t);
                }

                @Override
                public void onCancel() {
                    PurRepositoryDialog.this.repositoryMeta = null;
                    PurRepositoryDialog.this.hide();
                }
            });
            this.container.addEventHandler((XulEventHandler)this.repositoryConfigController);
            try {
                runner.initialize();
                this.show();
            }
            catch (XulException e) {
                SpoonFactory.getInstance().messageBox(e.getLocalizedMessage(), this.resourceBundle.getString("RepositoryConfigDialog.InitializationFailed"), false, 2);
                log.error((Object)this.resourceBundle.getString("RepositoryConfigDialog.ErrorStartingXulApplication"), (Throwable)e);
            }
        }
        catch (XulException e) {
            log.error((Object)this.resourceBundle.getString("RepositoryConfigDialog.ErrorStartingXulApplication"), (Throwable)e);
        }
        return this.repositoryMeta;
    }

    public Composite getDialogArea() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-config-dialog");
        return (Composite)dialog.getManagedObject();
    }

    public void show() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-config-dialog");
        dialog.show();
    }

    public void hide() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-config-dialog");
        dialog.hide();
    }

    public Shell getShell() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("repository-config-dialog");
        return (Shell)dialog.getRootObject();
    }

    private void displayRepositoryAlreadyExistMessage(String name) {
        try {
            XulMessageBox messageBox = (XulMessageBox)this.container.getDocumentRoot().createElement("messagebox");
            messageBox.setTitle(this.resourceBundle.getString("Dialog.Error"));
            messageBox.setAcceptLabel(this.resourceBundle.getString("Dialog.Ok"));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"PurRepositoryDialog.Dialog.ErrorIdExist.Message", (String[])new String[]{name}));
            messageBox.open();
        }
        catch (XulException e) {
            throw new RuntimeException(e);
        }
    }
}

