/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.repository.importexport;

import com.pentaho.repository.importexport.PDIImportUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.TransDelegate;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StreamToTransNodeConverter
implements Converter {
    IUnifiedRepository unifiedRepository;
    private static final Log logger = LogFactory.getLog(StreamToTransNodeConverter.class);

    public StreamToTransNodeConverter(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public InputStream convert(IRepositoryFileData data) {
        throw new UnsupportedOperationException();
    }

    public InputStream convert(Serializable fileId) {
        block8: {
            try {
                if (fileId == null) break block8;
                Repository repository = this.connectToRepository();
                RepositoryFile file = this.unifiedRepository.getFileById(fileId);
                if (file == null) break block8;
                try {
                    TransMeta transMeta = repository.loadTransformation((ObjectId)new StringObjectId(fileId.toString()), null);
                    if (transMeta != null) {
                        Set privateDatabases = transMeta.getPrivateDatabases();
                        if (privateDatabases != null) {
                            Iterator it = transMeta.getDatabases().iterator();
                            while (it.hasNext()) {
                                String databaseName = ((DatabaseMeta)it.next()).getName();
                                if (privateDatabases.contains(databaseName)) continue;
                                it.remove();
                            }
                        }
                        return new ByteArrayInputStream(transMeta.getXML().getBytes());
                    }
                }
                catch (KettleException e) {
                    logger.error((Object)e);
                    SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)this.unifiedRepository.getDataForRead(fileId, SimpleRepositoryFileData.class);
                    if (fileData != null) {
                        logger.warn((Object)("Reading as legacy CE tranformation " + file.getName() + "."));
                        return fileData.getInputStream();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    Repository connectToRepository() throws KettleException {
        return PDIImportUtil.connectToRepository(null);
    }

    public IRepositoryFileData convert(InputStream inputStream, String charset, String mimeType) {
        try {
            long size = inputStream.available();
            TransMeta transMeta = new TransMeta();
            Repository repository = this.connectToRepository();
            Document doc = PDIImportUtil.loadXMLFrom(inputStream);
            transMeta.loadXML((Node)doc.getDocumentElement(), repository, false);
            TransDelegate delegate = new TransDelegate(repository, this.unifiedRepository);
            this.saveSharedObjects(repository, (RepositoryElementInterface)transMeta);
            return new NodeRepositoryFileData(delegate.elementToDataNode((RepositoryElementInterface)transMeta), size);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSharedObjects(Repository repo, RepositoryElementInterface element) throws KettleException {
        TransMeta transMeta = (TransMeta)element;
        List<String> databaseNames = Arrays.asList(repo.getDatabaseNames(true));
        int dbIndex = 0;
        boolean updateMeta = Boolean.FALSE;
        ArrayList<Integer> transMetaDatabasesToUpdate = new ArrayList<Integer>();
        Repository repository = repo;
        synchronized (repository) {
            for (DatabaseMeta databaseMeta : transMeta.getDatabases()) {
                if (!databaseNames.contains(databaseMeta.getName())) {
                    if (databaseMeta.getObjectId() == null || !StringUtils.isEmpty((String)databaseMeta.getHostname())) {
                        repo.save((RepositoryElementInterface)databaseMeta, null, null);
                    }
                } else if (databaseMeta.getObjectId() == null) {
                    transMetaDatabasesToUpdate.add(dbIndex);
                    updateMeta = Boolean.TRUE;
                }
                ++dbIndex;
            }
            if (updateMeta) {
                for (Integer databaseMetaIndex : transMetaDatabasesToUpdate) {
                    transMeta.getDatabase(databaseMetaIndex.intValue()).setObjectId(repo.getDatabaseID(transMeta.getDatabase(databaseMetaIndex.intValue()).getName()));
                }
            }
            for (SlaveServer slaveServer : transMeta.getSlaveServers()) {
                if (!slaveServer.hasChanged() && slaveServer.getObjectId() != null) continue;
                repo.save((RepositoryElementInterface)slaveServer, null, null);
            }
            for (ClusterSchema clusterSchema : transMeta.getClusterSchemas()) {
                if (!clusterSchema.hasChanged() && clusterSchema.getObjectId() != null) continue;
                repo.save((RepositoryElementInterface)clusterSchema, null, null);
            }
            for (PartitionSchema partitionSchema : transMeta.getPartitionSchemas()) {
                if (!partitionSchema.hasChanged() && partitionSchema.getObjectId() != null) continue;
                repo.save((RepositoryElementInterface)partitionSchema, null, null);
            }
        }
    }

    public void convertPostRepoSave(RepositoryFile repositoryFile) {
        if (repositoryFile != null) {
            try {
                Repository repo = this.connectToRepository();
                if (repo != null) {
                    TransMeta transMeta = repo.loadTransformation((ObjectId)new StringObjectId(repositoryFile.getId().toString()), null);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)new LogChannel((Object)this), (String)KettleExtensionPoint.TransImportAfterSaveToRepo.id, (Object)transMeta);
                }
            }
            catch (Exception e) {
                logger.error((Object)KettleExtensionPoint.TransImportAfterSaveToRepo.id, (Throwable)e);
            }
        }
    }
}

