/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.revision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.PurObjectRevision;
import org.pentaho.di.repository.pur.UnifiedRepositoryRevisionService;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.platform.api.repository2.unified.IRepositoryVersionManager;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.webservices.FileVersioningConfiguration;
import org.pentaho.platform.web.http.api.resources.utils.FileUtils;

@Path(value="/pur-repository-plugin/api/revision")
public class RevisionResource {
    IUnifiedRepository repository;
    IRevisionService revisionService = null;
    static IRepositoryVersionManager repositoryVersionManager;

    public RevisionResource(IUnifiedRepository unifiedRepository) {
        this.repository = unifiedRepository;
        this.revisionService = new UnifiedRepositoryRevisionService(unifiedRepository, null);
    }

    @GET
    @Path(value="{pathId : .+}/revisions")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns list of revisions"), @ResponseCode(code=500, condition="Something failed when attempting to retrieve revisions"), @ResponseCode(code=404, condition="Invalid path")})
    @Produces(value={"application/xml", "application/json"})
    public Response doGetVersions(@PathParam(value="pathId") String pathId) {
        Serializable fileId = null;
        List<ObjectRevision> originalRevisions = null;
        RepositoryFile repositoryFile = this.repository.getFile(FileUtils.idToPath((String)pathId));
        if (repositoryFile != null) {
            fileId = repositoryFile.getId();
        }
        if (fileId != null) {
            try {
                originalRevisions = this.revisionService.getRevisions((ObjectId)new StringObjectId(fileId.toString()));
            }
            catch (KettleException e) {
                return Response.serverError().build();
            }
            ArrayList<PurObjectRevision> revisions = new ArrayList<PurObjectRevision>();
            for (ObjectRevision revision : originalRevisions) {
                revisions.add((PurObjectRevision)revision);
            }
            GenericEntity<List<PurObjectRevision>> genericRevisionsEntity = new GenericEntity<List<PurObjectRevision>>(revisions){};
            return Response.ok((Object)genericRevisionsEntity).build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="{pathId}/versioningConfiguration")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns the versioning configuation")})
    public FileVersioningConfiguration doVersioningConfiguration(@PathParam(value="pathId") String pathId) {
        if (repositoryVersionManager == null) {
            repositoryVersionManager = (IRepositoryVersionManager)PentahoSystem.get(IRepositoryVersionManager.class);
        }
        return new FileVersioningConfiguration(repositoryVersionManager.isVersioningEnabled(FileUtils.idToPath((String)pathId)), repositoryVersionManager.isVersionCommentEnabled(FileUtils.idToPath((String)pathId)));
    }

    public static void setRepositoryVersionManager(IRepositoryVersionManager repositoryVersionManager) {
        RevisionResource.repositoryVersionManager = repositoryVersionManager;
    }
}

